/*
*************************************************************************fil**
**		 ARETE SYSTEMS CORPORATION CONFIDENTIAL AND PROPRIETARY
**	This source is the sole property of ARETE SYSTEMS CORPORATION
**	Reproduction or utilization of this source in whole or in part
**	is forbiden whithout the written consent of 
**	ARETE SYSTEMS CORPORATION.
******************************************************************************
**
**			(c) Copyright ARETE SYSTEMS CORPORATION 1988
**			    All Rights Reserved.
******************************************************************************
**
**	FILE NAME:	rwiscc.h
**	TYPE:		C header file
**
**	DESCRIPTION:	This file contains definitions for the SCC chip
**			Z8030 SCC
**
**
******************************************************************************
*/ 


/*******************************************************************
 *
 *			S   C   C
 *
 *******************************************************************/

struct scc_reg {
	unsigned char filler;
	unsigned char reg;
};

struct scc {
	struct scc_reg reg[16];		/* 16 read/write registers */
};

/*******************************************************************
 *
 *	R E A D    R E G I S T E R S
 *
 *******************************************************************/

#define RR0_RX		0x01	/* rx ready */
#define RR0_ZERO	0x02	/* zero count */
#define RR0_TX		0x04	/* tx ready */
#define RR0_DCD		0x08	/* data carrier detect */
#define RR0_SYNC	0x10	/* sync */
#define RR0_HUNT	0x10	/* hunt */
#define RR0_CTS		0x20	/* clear to send */
#define RR0_TUR		0x40	/* tx underrun */
#define RR0_EOM		0x40	/* end of message */
#define RR0_BREAK	0x80	/* break */
#define RR0_ABORT	0x80	/* abort */

#define RR1_PAR		0x10	/* parity error */
#define RR1_ROR		0x20	/* rx overrun error */
#define RR1_FER		0x40	/* framing error */
#define RR1_CRC		0x40	/* crc error */
#define RR1_EOF		0x80	/* end of frame */

/*******************************************************************
 *
 *	W R I T E    R E G I S T E R S
 *
 *******************************************************************/

#define WR0_EXINT	0x10	/* reset external status interrupts */
#define WR0_TXINT	0x28	/* reset tx int pending */
#define WR0_ERROR	0x30	/* reset error */
#define WR0_RHIUS	0x38	/* reset highest priority int under service */
#define WR0_RXCRC	0x40	/* reset rx crc checker */
#define WR0_TXCRC	0x80	/* reset tx crc generator */
#define WR0_TXEOM	0xc0	/* reset tx underrun/eom */

#define WR1_EXTEN	0x01	/* external ints enable */
#define WR1_TXEN	0x02	/* transmitter ints enable */
#define WR1_PARSP	0x04	/* parity is special condition */
#define WR1_RX1ST	0x08	/* rx int on first or special */
#define WR1_RXALL	0x10	/* rx int on all or special */
#define WR1_RXSP	0x18	/* rx int on special only */

#define WR3_RXEN	0x01	/* receiver enable */
#define WR3_SYNC	0x02	/* sync char load inhibit */
#define WR3_ADDR	0x04	/* address search mode */
#define WR3_CRC		0x08	/* receiver crc enable */
#define WR3_HUNT	0x10	/* enter hunt mode */
#define WR3_AUTO	0x20	/* auto enables */
#define WR3_RX5		0x00	/* 5 or less tx bits */
#define WR3_RX7		0x40	/* 6 tx bits */
#define WR3_RX6		0x80	/* 7 tx bits */
#define WR3_RX8		0xc0	/* 8 tx bits */

#define WR4_PARITY	0x01	/* parity enable */
#define WR4_EVEN	0x02	/* parity even */
#define WR4_ODD		0x00	/* parity odd */
#define WR4_SYNC	0x00	/* sync modes enable */
#define WR4_1STOP	0x04	/* async 1 stop bit/character */
#define WR4_1.5STOP	0x08	/* async 1.5 stop bits/character */
#define WR4_2STOP	0x0c	/* async 2 stop bits/character */
#define WR4_8SYNC	0x00	/* 8 bit sync character */
#define WR4_16SYNC	0x10	/* 16 bit sync character */
#define WR4_SDLC	0x20	/* SDLC mode */
#define WR4_EXSYNC	0x30	/* external sync mode */
#define WR4_1CLOCK	0x00	/* x1 clock mode */
#define WR4_16CLOCK	0x40	/* x16 clock mode */
#define WR4_32CLOCK	0x80	/* x32 clock mode */
#define WR4_64CLOCK	0xc0	/* x64 clock mode */

#define WR5_TXCRCEN	0x01	/* transmitter crc enable */
#define WR5_RTS		0x02	/* request to send */
#define WR5_CRC16	0x04	/* crc-16 */
#define WR5_TXEN	0x08	/* transmitter enable */
#define WR5_BREAK	0x10	/* send break */
#define WR5_TX5		0x00	/* 5 or less tx bits */
#define WR5_TX7		0x20	/* 6 tx bits */
#define WR5_TX6		0x40	/* 7 tx bits */
#define WR5_TX8		0x60	/* 8 tx bits */
#define WR5_DTR		0x80	/* data terminal ready */

#define WR9_VIS		0x01	/* vector includes status */
#define WR9_NV		0x02	/* no vector */
#define WR9_DLC		0x04	/* disable lower chain */
#define WR9_MIE		0x08	/* master interrupt enable */
#define WR9_STHI	0x10	/* status high/low* */
#define WR9_BRST	0x40	/* channel B reset */
#define WR9_ARST	0x80	/* channel A reset */
#define WR9_HRST	0xc0	/* hardware reset */

#define WR11_BRGO	0x02	/* baud rate generator output */
#define WR11_TRXC	0x04	/* direction of the TRxC pin on the chip o/i* */
#define WR11_TCGO	0x10	/* use baud rate generator for transmit clock */
#define WR11_RCGO	0x40	/* use baud rate generator for receive clock */

#define WR14_ENABD  0x01    /* enable baud rate generator */
#define WR14_PCLK   0x02    /* pclk is source for baud rate generator */
#define WR14_DTR    0x04    /* DTR function */
#define WR14_AE     0x08    /* auto enables */
#define WR14_LL     0x10    /* local loopback mode */

#define WR15_ZCIE   0x02    /* zero count interrupt enable */
#define WR15_DCDIE  0x08    /* DCD interrupt enable */
#define WR15_SHIE   0x10    /* sync/hunt interrupt enable */
#define WR15_CTSIE  0x20    /* CTS interrupt enable */
#define WR15_TXUIE  0x40    /* transmitter underrun interrupt enable */
#define WR15_EOMIE  0x40    /* EOM interrupt enable */
#define WR15_BRKIE  0x80    /* break interrupt enable */
#define WR15_ABTIE  0x80    /* abort interrupt enable */

/* the below time constants assume a 4mhz source clock and x16 multiplier */
#define BDRT64K    0x0002  /* timer values for 64  baud */
#define BDRT38K    0x0001  /* timer values for 38.4k baud */
#define BDRT19K    0x0004  /* timer values for 19.2k baud */
#define BDRT9600   0x000a  /* timer values for 9600 baud */
#define BDRT4800   0x0016  /* timer values for 4800 baud */
#define BDRT2400   0x002e  /* timer values for 2400 baud */
#define BDRT1800   0x003e  /* timer values for 1800 baud */
#define BDRT1200   0x005e  /* timer values for 1200 baud */
#define BDRT600    0x00be  /* timer values for 600 baud */
#define BDRT300    0x017e  /* timer values for 300 baud */
#define BDRT200    0x023e  /* timer values for 200 baud */
#define BDRT150    0x02fe  /* timer values for 150 baud */
#define BDRT134    0x0356  /* timer values for 134.5 baud */
#define BDRT110    0x0415  /* timer values for 110 baud */
#define BDRT75     0x05fe  /* timer values for 75 baud */
#define BDRT50     0x08fe  /* timer values for 50 baud */
/*
*************************************************************************end**
**		 ARETE SYSTEMS CORPORATION CONFIDENTIAL AND PROPRIETARY
**	This source is the sole property of ARETE SYSTEMS CORPORATION
**	Reproduction or utilization of this source in whole or in part
**	is forbiden whithout the written consent of 
**	ARETE SYSTEMS CORPORATION.
******************************************************************************
*/ 
