
/*******************************************************************
 *
 *			R   T   C
 *
 *******************************************************************/

struct rtc {
	unsigned char control;			/* control register */
	unsigned char sec;			/* seconds */
	unsigned char min;			/* minutes */
	unsigned char hour;			/* hour */
	unsigned char day;			/* day */
	unsigned char date;			/* date */
	unsigned char month;			/* month */
	unsigned char year;			/* year */
};

/******************************************************************************
 *
 * control --- rtc control register
 *
 ******************************************************************************/
#define C_WR	   0x80  /* write bit */
#define C_RD	   0x80  /* read bit */
#define C_SIGN	   0x80  /* sign bit */


/******************************************************************************
 *
 * seconds --- seconds register
 *
 ******************************************************************************/
#define S_STOP	   0x80  /* stop bit */

/******************************************************************************
 *
 * hour --- hour register
 *
 ******************************************************************************/
#define H_KSTART   0x80  /* kick start bit */

/*****************************************************************************
*
*	mask defines
*
******************************************************************************/

#define	RTC_DAY_MASK	0x07
#define	RTC_MONTH_MASK	0x1F
#define	RTC_DATE_MASK	0x3F
#define	RTC_HOUR_MASK	0x3F
#define	RTC_MIN_MASK	0x7F
#define	RTC_SEC_MASK	0x7F
#define	RTC_YEAR_MASK	0xFF


