
#define	IOA_HERE		0		/* this is set if IOA here */ 
#define	IOSBA_HERE		1		/* this is set if IOSBA here */ 
#define PS_PER_SYS		5		/* Max Power Supply/system. */
#define Sbus_Num_Slot		16		/* Max Sbus Slot. */
#define	CAB_PER_SYS		7		/* Max Cabinets. */
#define	IOM_PER_SYS		4		/* Max IOM/System. */
#define	ICB_DEVS_PER_IOA	20		/* Max ICB devices / IOA. */
#define KERN_LENGTH		80		/* Max S/W Path name. */	
#define PATH_LENGTH		32		/* Max F/W Path name. */
#define PASSWORD_LENGTH		16		/* Max password length. */
#define SWITCHING_POWER		0
#define HC_POWER		1
#define NO_POWER_SUPPLY		0xff

/* SBUS DEFINES */

#define	SBUS_SPM		0		/* service processor module */
#define	SBUS_MM			1		/* memory module */
#define	SBUS_PM20		2		/* processor module 68020 */
#define	SBUS_IOM		3		/* i/o module */
#define	SBUS_GIO		4		/* generic i/o controller */
#define	SBUS_NO_BOARD		0xFF		/* no board present in slot */

/*  SBUS CONTROL WRITES */

#define		MODULE_DISABLE	0x32
#define		MODULE_ENABLE	0x33
#define		IF_DISABLE	0x34
#define		IF_ENABLE	0x35

struct local_sensor {
	unchar	five_volt		: 1;	
	unchar	aux_five_volt 		: 1;	
	unchar	twelve_volt		: 1;	
	unchar	aux_twelve_volt		: 1;	
	unchar	neg_twelve_volt		: 1;	
	unchar	aux_neg_twelve_volt	: 1;	
	unchar	cage_air		: 1; 
	unchar	unused			: 1;	
} ;
	
struct pwr_sensor {
	unchar	ps_id;
	unchar	scale_factor;
	unchar	five_volt		: 1;	
	unchar	twelve_volt		: 1;	
	unchar	neg_twelve_volt		: 1;	
	unchar	five_volt_current	: 1;	
	unchar	temp			: 1;
	unchar  unused0			: 1;	
	unchar  unused1			: 1;	
	unchar  unused2			: 1;	
};

struct cab_sensor {
	unchar	present		   	: 1;
	unchar	inlet_air	   	: 1;
	unchar	exhaust_air	   	: 1;
	unchar  unused0		   	: 1;	
	unchar  unused1		   	: 1;	
	unchar  unused2		   	: 1;	
	unchar  unused3		   	: 1;	
	unchar  unused4		   	: 1;	
};

/*	
**	This structure is imbedded in the novram below
**	due to padding, the size of the structure is not
**	affected, but the information has been changed.
**	The new structure will allow for IOSBA support.
*/
#ifdef	OLD_STRUCT
struct iom_slot {
	unchar	iom_slot;			/* the mutha of the IOA */
		unchar	icb_slot[ICB_DEVS_PER_IOA];
};
#endif

	
struct iom_slot {
	unchar	iom_slot;			/* the mutha of the IOA */
	unchar  ext_bd_type;
	union {
		unchar	icb_slot[ICB_DEVS_PER_IOA];
		unchar	ios_slot[MAX_CSS_SLOT];
	} io_bds;
};

	
/*------------------------------> prom area <---------------------------------*/

struct novram {
	unchar	novram_ver;			/* (1)	Novram version. */
	unchar	spm_boot_disk[PATH_LENGTH];	/* (32) SPM runtime */ 
	unchar	diag_boot[PATH_LENGTH];		/* (32) Diag Image. */ 
	unchar	css_slot[Sbus_Num_Slot];	/* (16) css slot id's */	
	struct	iom_slot iom_slot[IOM_PER_SYS];	/* (88) icb slot id's */
	struct  pwr_sensor main_pwr[PS_PER_SYS]; /* (15) main p/s present */
	struct	cab_sensor cab_present[CAB_PER_SYS]; /* (7)  cabinets present */
	struct	local_sensor spm_sensor;	/* (1) */
	unchar	diag_fly_by;			/* (1) For skipping diag */
	unchar	keywas;				/* (1) Key status. */
	unchar	cmdwas;				/* (1) Command Status. */
	unchar	boot_dev;			/* (1) Boot Device. */
	unchar	pwrstat;			/* (1) Word Realignment. */
	uchar	newpwr;				/* (1) New power indicator. */
	uchar	fill0;				/* (1) char spare. */
	uchar	fill1;				/* (1) char spare. */
	uchar	fill2;				/* (1) char spare. */


	uint	prom_spare0;	
	uint	prom_spare1;	
	uint	prom_spare2;	
	uint	prom_spare3;	
	uint	prom_spare4;	
	uint	prom_spare5;	
	uint	prom_spare6;	
	uint	prom_spare7;	
	uint	prom_spare8;	
	uint	prom_spare9;	
	uint	prom_spare10;	
	uint	prom_spare11;	
	uint	prom_spare12;	
	uint	prom_spare13;	
	uint	prom_spare14;	
	uint	prom_spare15;	
	uint	prom_spare16;	
	uint	prom_spare17;	
	uint	prom_spare18;	
	uint	prom_spare19;	
	uint	prom_spare20;	
	uint	rwi_val_crc;		/* Chksum of warning/shutdown. */
	uint	prom_crc;

/*-----------------------------> spm shared area <----------------------------*/

	unchar	inlet_air_low_warning;
	unchar	inlet_air_high_warning;
	unchar	inlet_air_low_shutdown;
	unchar	inlet_air_high_shutdown;

	unchar	exhaust_air_low_warning;
	unchar	exhaust_air_high_warning;
	unchar	exhaust_air_low_shutdown;
	unchar	exhaust_air_high_shutdown;

	unchar	main_ps_temp_low_warning;
	unchar	main_ps_temp_high_warning;
	unchar	main_ps_temp_low_shutdown;
	unchar	main_ps_temp_high_shutdown;

	unchar	five_volt_low_warning;
	unchar	five_volt_high_warning;
	unchar	five_volt_low_shutdown;
	unchar	five_volt_high_shutdown;

	unchar	twelve_volt_low_warning;
	unchar	twelve_volt_high_warning;
	unchar	twelve_volt_low_shutdown;
	unchar	twelve_volt_high_shutdown;

	unchar	neg_twelve_volt_low_warning;
	unchar	neg_twelve_volt_high_warning;
	unchar	neg_twelve_volt_low_shutdown;
	unchar	neg_twelve_volt_high_shutdown;

	unchar	five_volt_current_warning;
	unchar	five_volt_current_shutdown;

	unchar	cage_air_low_warning;
	unchar	cage_air_high_warning;
	unchar	cage_air_low_shutdown;
	unchar	cage_air_high_shutdown;

	unchar	cage_air_delta; 

	ushort	console_baud_rate;
	ushort	modem_baud_rate;
	ushort	printer_baud_rate;
	ushort	ups_baud_rate;

	unchar	password[PASSWORD_LENGTH];
	unchar	autoboot;			/* autoboot flag */
	unchar	magic_num;		/* initializing the ride thru time */
	unchar	rshutdown;		/* Runtime shutdown flag. */

	uint	shared_spare0;
	uint	shared_spare1;
	uint	shared_spare2;
	uint	shared_spare3;	
	uint	shared_spare4;	
	uint	shared_spare5;	
	uint	shared_spare6;	
	uint	shared_spare7;	
	uint	shared_spare8;	
	uint	shared_spare9;	
	uint	shared_spare10;	
	uint	shared_spare11;	
	uint	shared_spare12;	
	uint	shared_spare13;	
	uint	shared_spare14;	
	uint	shared_spare15;	
	uint	shared_crc;

/*----------------------------> spm runtime area <----------------------------*/

	uint	runtime_crc;
	uint	ups_spare1;
	uint	ups_spare2;
	uint	ups_spare3;
	unchar	shutdown;		/* clean shutdown flag */
	unchar	rubber_room;		/* Restricted mode flag. */
	unchar	poll;				/* Auto SENSOR polling flag. */
	unchar	kernel_boot_disk[KERN_LENGTH];	/* pathname to Kernel code */
	unchar	sa_boot_disk[KERN_LENGTH];    /* pathname to STANDALONE code. */
	unchar	runtime_end;			/* End of RUNTIME indicator. */
};


