/******************************************************************************
 *
 * miscellaneous defines 
 *
 ******************************************************************************/
#define NOP 0x4e71	/* 68000 nop instruction */
#define FALSE 0
#define TRUE 1
#define XOFF 0x40
#define NULL 0
#define ESCAPE 0x1b  /* ascii ESCAPE character */
#define STDOUT 0
#define STDERR 1
#define LOWORD(x) (((unsigned short *)&x)[1])
#define HIWORD(x) (((unsigned short *)&x)[0])
#define LWSHIFT(x) (x >> 2)
#define LWBOUND(x) ((x & 0x3) == 0)
#define SCTRSIZ 0x400
#define CQSIZ 16   /* queue size for i/o characters */
#define CBUFSIZ 80
#define DISINTS asm("	or.w	&0x0700,%sr")  /* interrupt mode 7 */
#define ENAINTS asm("	and.w	&0xf8ff,%sr")  /* interrupt mode 0 */
#define CONSPORT 0	/* The two consoles on the CPU */
#define DIAGPORT 1
#define BYTE 1
#define WORD 2
#define LWORD 4
#define MASK1	0x01
#define	MASK2	0x03
#define	MASK3	0x07
#define	MASK4	0x0f
#define	MASK5	0x1f
#define	MASK6	0x3f
#define	MASK7	0x7f
#define	MASK8	0xff


/*
 * baud rate table for cpu monitor console baud rate
 */
struct baud {
	unsigned short bdrate;
	unsigned char  bdmsb;
	unsigned char  bdlsb;
};

union location {
	unsigned char byte;
	unsigned short word;
	unsigned lword;
};

typedef unsigned char boolean;
