
/******************************************************************************
                   (C)  COPYRIGHT ARIX CORPORATION 1988.
         ALL RIGHTS RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,
          REPRODUCED, OR TRANSLATED TO ANOTHER LANGUAGE WITHOUT THE PRIOR
                    WRITTEN CONSENT OF ARIX CORPORATION.
*******************************************************************************
*
*  PGNAME:  iosba_addr.h  (header filename)
*
*  PURPOSE:
*    Header file defining the IOSBA Read/Write Register address assignments
*    for the TARGET device testing environment.
*
*  METHOD:	N/A
*
*  INPUT: 	N/A
*
*  OUTPUT:	N/A 
*
*  REVISION:	A
*
*  LAST MODIFIED:
*    07/21/89(grw)    Initial creation
*
*******************************************************************************
*/

#define IOSBA		0x0f		/* upper nibble for the IOSBA  */

/* IOPM Tick Counter Register address assignment
*/
#define  IOPM_TICK_REG_ADDR	0x0C000002 

/* IOSBA Board Environment definitions
*/

/***************** Test and Control Registers ***************************/
/*									*/
/*	these registers are byte read-writable				*/
/*									*/
/************************************************************************/

#define IOSBA_WR_CONTROL 0xFFFFE000	/* module write control 	*/
#define	IOSBA_CTL_ERROR	0xFFFFE800	/* error register	(byte) 	*/
#define	IOSBA_INTR_VECT	0xFFFFE804	/* interrupt vector	(byte)	*/	
#define	IOSBA_INTR_LVL	0xFFFFE805	/* interrupt level	(byte)	*/
#define	IOSBA_INTR_DST	0xFFFFE806	/* interrupt dest	(byte)	*/

#define	IOSBA_RST_CTRL	0xFFFFE900	/* reset control	(byte)	*/
#define	IOSBA_TST_MODE	0xFFFFE901	/* test mode control	(byte)	*/
#define IOSBA_TST_UNLD	0xFFFFE902	/* test unload control	(byte)	*/
#define IOSBA_ERR_GEN1A	0xFFFFE904	/* error gen reg 1A	(byte)	*/
#define IOSBA_ERR_GEN1B	0xFFFFE905	/* error gen reg 1B	(byte)	*/
#define IOSBA_ERR_GEN1C	0xFFFFE906	/* error gen reg 1C	(byte)	*/
#define IOSBA_ERR_GEN1D	0xFFFFE907	/* error gen reg 1D	(byte)	*/


/***************** Status Registers *************************************/
/*									*/
/*	these registers are long word read-writable			*/
/*									*/
/************************************************************************/

#define IOSBA_ST_DL_ERR	0xFFFFEA00	/* status dl error	(long)	*/
#define	IOSBA_ST_GRNT_TMO 0xFFFFEA04	/* status grant timeout (long)	*/
#define	IOSBA_ST_XMT_ERR  0xFFFFEA08	/* status transmit err  (long)	*/
#define	IOSBA_ST_IOSB_ERR 0xFFFFEA0C	/* status system bus err(long)	*/
#define	IOSBA_ST_UL_ERR	0xFFFFEA10	/* status ul error 	(long)	*/
#define	IOSBA_ST_CARD	0xFFFFEA14	/* card slot status  ID	(long)	*/
#define	IOSBA_ST_ID	0xFFFFEFF4	/* module ID			*/

/***************** Card Id value ****************************************/
#define CARD_ID_VALUE	0x07		

/***************** Fifo Control  Registers ******************************/
/*									*/
/*	these registers are byte read-writable				*/
/*									*/
/************************************************************************/

#define	IOSBA_DL_CMD_AR	0xFFFFEB00	/* dl command fifo A reg(byte)	*/
#define	IOSBA_DL_CMD_BR	0xFFFFEB04	/* dl command fifo B reg(byte)	*/
#define	IOSBA_DL_RSP_AR	0xFFFFEB08	/* dl resp fifo A reg	(byte)	*/
#define	IOSBA_DL_RSP_BR	0xFFFFEB0C	/* dl resp fifo B reg	(byte)	*/
#define	IOSBA_UL_CMD_AR	0xFFFFEB10	/* ul command fifo A reg(byte)	*/
#define	IOSBA_UL_CMD_BR	0xFFFFEB14	/* ul command fifo B reg(byte)	*/
#define	IOSBA_UL_RSP_AR	0xFFFFEB18	/* ul resp fifo A reg	(byte)	*/
#define	IOSBA_UL_RSP_BR	0xFFFFEB1C	/* ul resp fifo B reg	(byte)	*/

#define	IOSBA_DL_CMD_AP	0xFFFFEB20	/* dl command fifo A ptr(byte)	*/
#define	IOSBA_DL_CMD_BP	0xFFFFEB24	/* dl command fifo B ptr(byte)	*/
#define	IOSBA_DL_RSP_AP	0xFFFFEB28	/* dl resp fifo A ptr	(byte)	*/
#define	IOSBA_DL_RSP_BP	0xFFFFEB2C	/* dl resp fifo B ptr	(byte)	*/
#define	IOSBA_UL_CMD_AP	0xFFFFEB30	/* ul command fifo A ptr(byte)	*/
#define	IOSBA_UL_CMD_BP	0xFFFFEB34	/* ul command fifo B ptr(byte)	*/
#define	IOSBA_UL_RSP_AP	0xFFFFEB38	/* ul resp fifo A ptr	(byte)	*/
#define	IOSBA_UL_RSP_BP	0xFFFFEB3C	/* ul resp fifo B ptr	(byte)	*/

/************** register bit definitions ********************************/

/************************************************************************/
/* 	MODULE WRITE CONTROL 0xFFFFE000
	used to enable and disable module interfaces and modules
*/
/************************************************************************/
#define	MOD_DISABLE	  0x00
#define MOD_ENABLE	  0x01
#define INTERFACE_DISABLE 0x02
#define INTERFACE_ENABLE  0x03
#define CONTROL_MASK	  0x03
#

/************************************************************************/
/*     	IOSBA_CTL_ERROR	0xFFFFE800	 error register		        	*/
/************************************************************************/
#define	CTL_ERROR_GTO	0x01		/* grant timeout		*/
#define	CTL_ERROR_XE	0x02		/* dl fifo err during IOSB xmt	*/
#define	CTL_ERROR_BE	0x04		/* ios bus error		*/
#define	CTL_ERROR_DL	0x08		/* dl error detected		*/
#define	CTL_ERROR_CSD	0x10		/* dl command or type field err */
#define	CTL_ERROR_UL	0x20		/* ul error detected		*/
#define	CTL_ERROR_UCSD	0x40		/* ul command or type error 	*/
#define	CTL_ERROR_EOI	0x80		/* an error int has been sent	*/

/************************************************************************/
/*    IOSBA_INTR_LVL	0xFFFFEB05	 interrupt level	        */
/************************************************************************/
#define INTRL_LVL_D	0x80		/* 1 = directed interrupt	*/

/************************************************************************/
/*    IOSBA_INTR_DST	0xFFFFEB06	 interrupt dest		        */ 
/************************************************************************/
/* bits 0 - 3 = bus destination						*/
/* bits 4 - 7 = dest slot						*/

/************************************************************************/
/*    IOSBA_RST_CTRL	0xFFFFE900	 reset control		        */
/************************************************************************/
#define	RST_CTRL_ARST	0x01		/* local IOSBA reset		*/
#define	RST_CTRL_LRST	0x02		/* local IOSBA link circuit rst */
#define	RST_CTRL_BRST	0x04		/* assert IOSB reset		*/
#define	RST_CTRL_FRST	0x08		/* assert FIFO reset		*/
#define	RST_CTRL_ERST	0x10		/* assert error reset		*/
#define	RST_CTRL_FLT	0x40		/* turn on front panel red FLT led   */
#define	RST_CTRL_RDY	0x80		/* turn on front panel green RDY led */


/************************************************************************/
/*    IOSBA_TST_MODE	0xFFFFE901	 test mode control	        */
/************************************************************************/
#define	TST_MODE_IR	0x01	/* enable IOSBA interrupt write to 
				   be sent up the link		*/
#define	TST_MODE_DLWR	0x02	/* dl write commands converted to
				   responses			*/
#define	TST_MODE_TXEN	0x04	/* enable IOSB output section	*/
#define	TST_MODE_IOXD	0x08	/* disable driving expansion	*/
#define	TST_MODE_FRDY	0x10	/* force iosb ready cntr to rdy */
#define	TST_MODE_RXEN	0x20	/* enable iosb input section	*/
#define	TST_MODE_ATOE	0x40	/* disable arb grant timeouts	*/
#define	TST_MODE_LPE	0x80	/* enable IOSB loopback		*/

/************************************************************************/
/*    IOSBA_TST_UNLD	0xFFFFE902	 test unload control	        */
/************************************************************************/
#define	TST_UNLD_ULCU	0x01		/* disable ul command fifo unload */
#define	TST_UNLD_ULRU	0x02		/* disable ul response fifo unload*/
#define	TST_UNLD_UCX	0x04		/* 0-1 transition enables one uplink
					   upload in disabled		  */
#define	TST_UNLD_URX	0x08		/* 0-1 transition enables one uplink
					   upload in disabled		  */
#define	TST_UNLD_DLCU	0x10		/* disable dl comm fifo unloading */
#define	TST_UNLD_DLRU	0x20		/* disable dl resp fifo unloading */

/************************************************************************/
/*    IOSBA_ERR_GEN1A	0xFFFFE904	 error gen reg 1A	        */
/************************************************************************/
#define	ERR_GEN_DE3_NOT	0x80	/* there bits invert the corresponding	*/
#define	ERR_GEN_DE2_NOT	0x40	/* BUS.DEST* bit forcing an IOSB 	*/
#define	ERR_GEN_DE1_NOT	0x20	/* destination error			*/
#define	ERR_GEN_DE0_NOT	0x10	/*					*/

#define	ERR_GEN_DE3	0x08	/* there bits invert the corresponding	*/
#define	ERR_GEN_DE2	0x04	/* BUS.DEST bit forcing an IOSB 	*/
#define	ERR_GEN_DE1	0x02	/* destination error			*/
#define	ERR_GEN_DE0	0x01	/*					*/

/************************************************************************/
/*    IOSBA_ERR_GEN1B	0xFFFFE905	 error gen reg 1B	        */
/************************************************************************/
#define	ERR_GEN_SE3_NOT	0x80	/* there bits invert the corresponding	*/
#define	ERR_GEN_SE2_NOT	0x40	/* BUS.SRC* bit forcing an IOSB 	*/
#define	ERR_GEN_SE1_NOT	0x20	/* source error				*/
#define	ERR_GEN_SE0_NOT	0x10	/*					*/

#define	ERR_GEN_SE3	0x08	/* there bits invert the corresponding	*/
#define	ERR_GEN_SE2	0x04	/* BUS.SRC bit forcing an IOSB 		*/
#define	ERR_GEN_SE1	0x02	/* source error				*/
#define	ERR_GEN_SE0	0x01	/*					*/

/************************************************************************/
/*    IOSBA_ERR_GEN1C	0xFFFFE906	 error gen reg 1C	        */
/************************************************************************/
#define	ERR_GEN_DA0	0x01	/* forces IOSB data parity error by 	*/
#define	ERR_GEN_DA1	0x02	/* inverting BUS.DATA.PAR for the 	*/
#define	ERR_GEN_DA2	0x04	/* specified bits when driven on the 	*/
#define	ERR_GEN_DA3	0x08	/* IOSB bus				*/
#define	ERR_GEN_DA4	0x10	/* 					*/
#define	ERR_GEN_DA5	0x20	/* 					*/
#define	ERR_GEN_DA6	0x40	/* 					*/
#define	ERR_GEN_DA7	0x80	/* 					*/

/************************************************************************/
/*    IOSBA_ERR_GEN1D	0xFFFFE907	 error gen reg 1D	        */
/************************************************************************/
#define ERR_GEN_IOTE	0x01	/* forces IOSB type error by inv BUS.TYP.ERR */
#define	ERR_GEN_XTE	0x02	/* forces dl fifo output type parity error   */
#define	ERR_GEN_XSE	0x04	/* forces dl fifo output sbslot or ioslot par*/
#define	ERR_GEN_USE	0x10	/* force uplink fifo slot parity error	     */
#define	ERR_GEN_LTE	0x20	/* forces dl type error on non-local accesses*/
				/* by inverting LNK_TYP_PAR on reception     */
#define	ERR_GEN_LIOE	0x40	/* forces downlink ioslot error on non-local */
				/* acesses by inverting LNK.TYPE.PAR on recpt*/
#define	ERR_GEN_LSBE	0x80	/* forces downling ioslot error on non-local */
				/* accesses				     */


/***************** Status Registers *************************************/

/************************************************************************/
/*    IOSBA_ST_DL_ERR	0xFFFFEA00	 status dl error	        */
/************************************************************************/
#define ST_DL_IO4	0x00000040	/* received ioslot 4 set if err	*/
#define	ST_DL_COVF	0x00010000	/* command fifo overflow	*/
#define	ST_DL_ROVF	0x00020000	/* receive fifo overflow	*/
#define	ST_DL_LOVF	0x00040000	/* set if a local command pend	*/
#define	ST_DL_R2R	0x00080000	/* 1st byte of 2 byte err resp rcv */
#define	ST_DL_R6R	0x00100000	/* 1st byte of 2 byte rsp recieved */
#define	ST_DL_WR	0x00200000	/* 1 byte of a 2 byte command rcvd */
#define	ST_DL_ACW	0x00400000	/* address space if for control wrt*/
#define	ST_DL_ALOC	0x00800000	/* address space if for local regs */
#define ST_DL_TE	0x10000000	/* type error detected		*/
#define	ST_DL_SBE	0x20000000	/* SBSLOT error detected	*/
#define	ST_DL_IOE	0x40000000	/* IOSLOT error detected	*/
#define	ST_DL_R6E	0x80000000	/* an error occurred in 1st 4 bytes 
					 of an 8 byte response	*/
/*	bits 30:33	data parity error 0-3 detected			*/
/*	bits 14:17	received link sbslot field			*/
/*	bits 10:13	received link ioslot field			*/
/*	bits 0:05	received link type field			*/
/*	all other bits are unused					*/

/************************************************************************/
/*    IOSBA_ST_GRNT_TMO 0xFFFFEA04	 status grant timeout           */
/************************************************************************/
#define	ST_GRNT_TYP3	0x00000010	 /* iosb type bit 3		*/
#define	ST_GRNT_TYP4	0x00000010	 /* iosb type bit 4		*/
#define	ST_GRNT_TYP5	0x00000010	 /* iosb type bit 5		*/
/*	bits 14:17	sbslot (iosb source field)			*/
/*	bits 10:13	ioslot (iosb destination field)			*/
/*	bits 0:3	iosb arbitrations destination			*/
/*	all other bits are unused					*/

/************************************************************************/
/*    IOSBA_ST_XMT_ERR  0xFFFFEA08	 status transmit err            */
/************************************************************************/
#define	ST_XMT_OE	0x00000001	/* error in uplink fifo parity
					   for or of sbslot or ioslot	*/
#define	ST_XMT_TE	0x00000080	/* type parity error from 
					   downlink fifo		*/
/*	bits 1:6	iosb type field					*/
/*	bits 10:13	ioslot (iosb destination field)			*/
/*	bits 14:17	sbslot (iosb source field)			*/

/************************************************************************/
/*    IOSBA_ST_IOSB_ERR 0xFFFFEA0C	 status system bus err          */
/************************************************************************/
#define	ST_IOSB_NACK	0x00000001	/* received nack		*/
#define	ST_IOSB_ACK	0x00000002	/* receive ack			*/
#define	ST_IOSB_COVF	0x00000004	/* uplink response fifo overflow*/
#define	ST_IOSB_ROVF	0x00000008	/* uplink command fifo overflow	*/
#define	ST_IOSB_SBA	0x00004000	/* IOSBA was driver of bus 
					   					when error was detected	*/
#define	ST_IOSB_RA	0x00010000	/* IOSB active			*/
#define	ST_IOSB_RXA	0x00020000	/* IOSB iox active		*/
#define	ST_IOSB_DPV	0x00040000	/* Data parity valid signal	*/
#define	ST_IOSB_DPE	0x00080000	/* Data parity error detected	*/
#define	ST_IOSB_TE	0x00100000	/* Type error detected		*/
#define	ST_IOSB_DE	0x00200000	/* Destination error detected	*/
#define ST_IOST_SE	0x00400000	/* Source error detected	*/
/*	bits 10:15	IOSB bus type 					*/
/*	bits 30:33	IOSB source field				*/
/*	bits 34:37	IOSB destination field				*/
/*	all other bits are unused					*/

/************************************************************************/
/*    IOSBA_ST_UL_ERR	0xFFFFEA10	 status ul error 	        */
/************************************************************************/
#define	ST_UL_OE	0x00000100	/* error in uplink fifo parity 
		   			for or of sbslot, ioslot, lock */
#define	ST_UL_TPP	0x00000800	/* type parity error from ul fifo */
#define	ST_UL_LOCN	0x00010000	/* tag number if part of locked seq*/
#define	ST_UL_LOC	0x00020000	/* 0 = entry is part of a locked seq*/
/*	bits 11:16	link type field					*/
/*	bits 00:03	link ioslot field				*/
/*	bits 04:07	link sbslot field				*/

#define	TYPE_IOA	(uchar)0x00
#define	TYPE_IOSBA	(uchar)0x07
#define	NO_ADAPTER	(uchar)0xFF
