
/*
	iopm_comm.h
	Tim Patrick
	ARIX Corporation
	Wed Aug  2 01:31:55 PDT 1989
*/

	
typedef  struct iop_comm {
	uint    iop_magic;
	uint    o_boot_response;
	char    input_buf;
	char    input_buf_full;
	char    output_buf;
	char    output_buf_full;
	uint	ctlflg;			/* Contrl flag			*/
	uint	entry;			/* Entry point for IOPM 	*/
	uint	istatus;		/* Command status       	*/
	uint	icmd;			/* Input command		*/
	uint	ostatus;		/* Coomand status	        */
	uint	ocmd;			/* Output command		*/
	char	fname[16];		/* File name to be loaded 
					   also version	information	*/
	uint	settime_int;		/* 4-20-89 Added for spm disp. int. */
	ushort  ret_code;		/* device read return code */
	ushort  dev_type;		/* type of devices used for read */
	uint	st_block;		/* starting block number  */
	uint	num_block;		/* number of blocks  */
	ushort	phys_dev;		/* physical device number */
	ushort	log_dev;		/* logical device number */
	uint	mem_slot;		/* memory slot used by load and jump */
	uint	mem_offset;		/* offset used by load and jump */
} IOP_COMM_BLK, *IOP_COMM_PTR;

/*
	IOPM addresses from the perspective of the SPM (or CSS client)
	The base address here assumes the use of map register 2 (MAP02)
	with the uppermost 4 address bits set to F (addr)

	Note: ifdef the IOPM_BASE value for the CSS versus IOPM perspective.
*/

#define IOPM_BASE		0xA0000000

#define IOP_RAM_START		((unsigned)IOPM_BASE + 0x08000000)
#define IOPM_DEV_BD_ID   	((unsigned)IOPM_BASE)
#define IOPM_COMM_ADDR  	((unsigned)IOPM_BASE + 0x08000100)
#define SCSI_COMM_ADDR2  	((unsigned)IOPM_BASE + 0x08000200)
#define SCSI_COMM_ADDR8  	((unsigned)IOPM_BASE + 0x08000800)
#define IOPM_RD_ADDR  	 	((unsigned)IOPM_BASE + 0x080A0000)

/*	
	Valid values returned in the status field of the 
	command structure.
*/
#define		CSS_OWNED	(uint)0x00
#define		IOPM_OWNED	(uint)0x01

/*
	Valid commands which may be used in the command field of
	the structure.
*/
#define		IOPM_R_DEV		(uint)0x0001
#define		IOPM_RSMXL		(uint)0x0002
#define		IOPM_PROM_VER		(uint)0x0003
#define		IOPM_EEPROM_VER 	(uint)0x0004
#define		IOPM_BLOCK_NUM  	(uint)0x0005
#define		GET_DEV_TYPE		(uint)0x0006
#define		REWIND_TAPE		(uint)0x0007
#define		TAPE_SKIP		(uint)0x0008
#define		IOPM_W_DEV		(uint)0x0009

/*
	This is the bit which indicates a device board is bootable
*/
#define		IOPM_BOOTABLE_DEV	0x80

/*
	On the SCSI device board for IOPM, the follow device types are
	returned in the dev_type field of the structure.  This is only for
	SCSI and is used to try and determine if user error may have caused
	the boot to fail.
*/
#define		DISK_DEVICE		0x00
#define		TAPE_DEVICE		0x01
#define		WORM_DEVICE		0x04

/*
	Magic numbers used by the SPM and IOPM during power-up.  These will be
	exchanged in the IOPM local memory at the 'iop_magic' element of the
	iopm common structure.
*/

#define		SPM_MAGIC_NUM		0xDB61F2D2
#define		IOPM_MAGIC_NUM		0xACE0ACE1

/*
** magic number to coordinate versions of kernel and iop common and spm.
*/
#define IOPMAGIC  0x12221988

