

/* 
	flp_cmd.h   
*/


struct	flp_cmd {
	uchar	cmd1;
	uchar	cmd2;
	union	args_cmd {
		struct	rd_wr_cmd {
			uchar	cyl;
			uchar	head;
			uchar	sect;
			uchar	nbyte;
			uchar	eot;
			uchar	gpl;
			uchar	dtl;
			uchar	pad;
			}rd_wr;
		struct	format_cmd {
			uchar	nbyte;
			uchar	spt;
			uchar	fmt_gpl;
			uchar	fbyte;
			}format;
		struct	seek_cmd {
			uchar	new_cyl;
			uchar	pad1;
			uchar	pad2;
			uchar	pad3;
			}seek;
		struct	spec_cmd {
			uchar	hlt;
			uchar	pad1;
			uchar	pad2;
			uchar	pad3;
			}specify;
		}args;
	};

union	flp_res {
	struct	other_res {
		uchar	st0;
		uchar	st1;
		uchar	st2;
		uchar	cyl;
		uchar	head;
		uchar	sect;
		uchar	nbyte;
		uchar	pad1;
		}other;
	struct	seek_res {
		uchar	st0;
		uchar	cyl;
		uchar	pad1;
		uchar	pad2;
		}seek;
	struct	recal_res {
		uchar	st0;
		uchar	cyl;
		uchar	pad1;
		uchar	pad2;
		}recal;
	struct	sds_res {
		uchar	st3;
		uchar	pad1;
		uchar	pad2;
		uchar	pad3;
		}sds;
	};


#define NBYTES	2		/* code for 512 bytes per sector */
#define RPM_SP	0x00		/* code for 500 rpm */
#define SPT	0x0F		/* sectors per track */
#define EOT	0x0F		/* last sector on track */
#define GPL	0x2a		/* gap length for PCAT */
#define FMT_GPL	0x50		/* gap length format, gap3 size */
#define DTL	0xff		/* data length superceded by NBYTES code */
#define FFB	0xf6		/* format filler byte */

#define FLP_RETRY  5	/* how many times to try for good status */

/*
	Floppy Drive Controller Addresses
*/
#define	MSR	((unsigned char *)0x09000000)	/* master status register (ro)*/
#define DATA	((unsigned char *)0x09000001)	/* data register */
#define OPS	((unsigned char *)0x09000003)	/* operations register (wo) */
#define CNTL	((unsigned char *)0x09000005)	/* control register (wo) */
#define	FDBITS	((unsigned char *)0x7000022)	/* PAL lines, contrl reg. */


/*	
	FLOPPY COMMAND HELPERS
		# +----MT
		# !+---MF
		# !!+--SK
		# 0100.0000
*/
#define MT	0		/* multi track mode flag */
#define MF	0x40		/* MFM mode flag */
#define SK	0x00		/* skip deleted address mark */


/*
	WD37C65 FLOPPY DISK SUBSYSTEM CONTROLLER COMMANDS 
*/
 
#define	F_RDTRK		0x02		/* read track */
#define	F_SPEC		0x03		/* specify */
#define	F_SDS		0x04		/* sense drive status */
#define	F_WRITE		0x05		/* write */
#define	F_READ		0x06		/* read data */
#define	F_RECAL		0x07		/* recalibrate */
#define	F_SIS		0x08		/* sense interrupt status */
#define	F_WRITED	0x09		/* write deleted data */
#define	F_RDID		0x0a		/* read ID */
#define	F_READD		0x0c		/* read deleted data */
#define	F_FMT		0x0d		/* format a track */
#define	F_SEEK		0x0f		/* seek */
#define	F_SCAN		0x11		/* scan equal */
#define	F_SCANL		0x19		/* scan low or equal */
#define	F_SCANH		0x1d		/* scan high or equal */

/*
	Commands used by floppy driver
*/
#define	FD_RDSEC	(F_READ  | MT | MF | SK)
#define	FD_WRSEC	(F_WRITE | MT | MF | SK)
#define	FD_RDTRACK	(F_RDTRK | MF | SK)
#define	FD_RDID		(F_RDID  | MF)
#define	FD_SEEK		(F_SEEK)
#define	FD_RECAL	(F_RECAL)
#define	FD_FMT  	(F_FMT   | MF)
#define	FD_SDS  	(F_SDS)
#define	FD_SIS  	(F_SIS)
#define	FD_SPEC		(F_SPEC)

#define	FD_HEAD0	0x00
#define	FD_HEAD1	0x04

#define	SPEC1		0x8F
#define	SPEC2		0x33
/*	
	FLOPPY BASE VALUES -- Motor Control
*/
 

#define	FDmotOn		0x00
#define	FDmotOff	0x80
#define	FDdack		0x40
#define	FDpre		0x20
#define M_ON		(FDdack | FDpre | FDmotOn)
#define M_OFF		(FDdack | FDpre | FDmotOff)

/* 
	OPERATIONS REGISTER DEFINITIONS 
*/
 
#define	OPS_RESET	0x00
#define	OPS_SRST	0x04
#define	OPS_DMAEN	0x08
#define	OPS_MOEN1	0x10
#define	CNTRLwd		(OPS_SRST | OPS_DMAEN | OPS_MOEN1)

/* 
	Master Status Register Bits 
*/
 
#define	MSRMSK	0xc0
#define	MSREXM	0x20		/* Execution Mode. Low=result phase */
#define	MSRCB	0x10		/* FDC busy doing a READ/WRITE */
#define	MSRDXB	0x0f		/* FDD 0-3 busy, LSB=0. */
#define	MSRcmd  0x80		/* command phase, need data from cpu */
#define	MSRresp 0xc0		/* response phase, data ready */
#define MSRrd	0xe0		/* ready with read data */
#define MSRwr	0xa0		/* ready for write data */

/*
	Floppy error array defines
*/
#define RDERR	(flp_errors[0])		/* read errors */
#define SKERR	(flp_errors[1])		/* seek errors */
#define WRERR	(flp_errors[2])		/* write errors */
#define CPERR	(flp_errors[3])		/* compare errors */

/*
	Defined limits
*/
#define	MAX_CYL_NUM		79
#define	NUMBER_CYLINDERS	80
#define	NUMBER_HEADS		 2
#define SECT_CYL		30
#define	SECT_HEAD		15
#define	TOTAL_SECT		(30 * 80)
#define	SECT_SZ			512
#define	MAX_ERRORS		16


#define	FLP_READ		0
#define	FLP_WRITE		1

#define	SEND1			1
#define	SEND2			2
#define	SEND3			3
#define	SEND6			6
#define	SEND9			9

#define	RW0			0
#define	RW_SEC			512
#define RW_TRACK		(15 * 512)

#define	RES7			7
#define SIS_RES			2

#define EXM_NOT_DONE 		(*MSR & MSREXM)
	
#define	RD_WR_TIMEOUT 		4000
#define	SEEK_TIMEOUT 		4000
#define	RES_TIMEOUT 		4000
#define	FMT_TIMEOUT 		4000
#define	EXM_TIMEOUT		2000
#define	SEND_TIMEOUT		200

#define	FLP_TIME		0xFFFFFFFF

#define	FDELAY_CNT		0x400
/*
	Used by recal, seek, fcmdinit, and ready changes to indicate
	a recalibrate is needed.  This value is assigned to current_cyl
	where it is out of range.
*/
#define	NEED_RECAL		0xFF

/*
	Error codes 
*/


#define	SEND_FAIL	0x10000000
#define	RES_FAIL	0x20000000
#define	RES_INT_FAIL	0x30000000
#define SENSE_FAIL	0x40000000
#define	CMD_FAIL	0x50000000
#define CMD_INT_FAIL	0x60000000

#define EXM_FAIL	0x80000000
#define INVL_CMD	0xf0000000

#define SEND_EXM_FAIL	(SEND_FAIL | EXM_FAIL)
#define	SENSE_EXM_FAIL 	(SENSE_FAIL | EXM_FAIL)


#define	RD_FAIL  	0x01000000
#define	WR_FAIL  	0x02000000
#define	RECAL_FAIL	0x04000000
#define	SEEK_FAIL	0x08000000

#define SEEK_NOT_DONE 	0x00000100
#define EQIP_CHK 	0x00000200
#define CMD_DNC 	0x00000400
#define CMD_INVL 	0x00000800
#define WRONG_UNIT 	0x00001000
#define DATA_ERROR 	0x00002000
#define OVERRUN 	0x00004000
#define NO_DATA 	0x00008000
#define NOT_WRITE 	0x00010000
#define MISS_ADDR 	0x00020000
#define WRONG_CYL 	0x00040000
#define BAD_CYL 	0x00080000
#define	CNTL_MARK 	0x00100000
#define	CRC_ERR 	0x00200000

