
#include "types.h"

#define		ESCAPE	'\033'

#define	NUM_CMD_BUF	8
#define CMD_BUF_SIZE	64

extern char cmd_buf [NUM_CMD_BUF][CMD_BUF_SIZE];
extern uint current_buf;
uchar   cur_col;

#define	RELATIVE_BUF(buf_num) (buf_num % NUM_CMD_BUF)

buf_edit (limit, copy_buf_num)
uint	limit;
uint	copy_buf_num;
{
	register char *buf = cmd_buf[RELATIVE_BUF(current_buf)];
	register char *buf_ptr = buf;
	register char *buf_end = (char *)((unsigned)buf + (unsigned)limit);
	register uchar typed;
	register uint cnt;
	register uchar cur_col_save;

#ifdef	BUF_DEBUG
printf ("enter buf_edit, c_b:  %d.\n", current_buf);
#endif
	typed = Getchar () & 0177;	/* only take 7 bits */
	while (1) {
		
		switch (typed) {
			
			case 'k':	/* show previous command */
				/* if previous command exists */
				if (copy_buf_num == 0) 
					break;

				/* Get previous command */
				copy_buf_num--;	  

				/* copy command buffers and display command */
				move_command (limit, copy_buf_num);

				/* get current command pointers again */
				buf = cmd_buf[RELATIVE_BUF(current_buf)];
				buf_ptr = buf;
				buf_end = (char *)((uint)buf + (uint)limit);
				break;

			case 'j':	/* show next command */
				
				/* Get next command  */
				copy_buf_num++;

				/* copy command buffers and display command */
				move_command (limit, copy_buf_num);

				/* get current command pointers again */
				buf = cmd_buf[RELATIVE_BUF(current_buf)];
				buf_ptr = buf;
				buf_end = (char *)((uint)buf + (uint)limit);
				break;

			case 'l':
				if (*buf_ptr && buf_ptr < buf_end) {
					putchar (*buf_ptr++);
					cur_col++;
				}
				if (!(*buf_ptr)) { /* moved to the NULL */
					putchar('\b');
					buf_ptr--;
					if (cur_col)
						cur_col--;
				}
				break;
			case 'h':
				if (buf_ptr > buf) {
					putchar ('\b');
					buf_ptr--;
					if (cur_col)
						cur_col--;
				}
				break;
			case 'D':
				cnt = 0;
				while (*buf_ptr && buf_ptr < buf_end) {
					*buf_ptr++ = (char)0;
					putchar(' ');
					cnt++;
				}
				while (cnt--) {
					putchar('\b');
					buf_ptr--;
				}
				break;
			case 'x':
				delete_char (buf_end, buf_ptr);
				break;
			case 'd':
				delete_word (buf, buf_end, buf_ptr);
				break;
			case 'i':
				insert_chars (buf_end, buf_ptr);
				break;
			case 'c':
				cur_col_save = cur_col;
				delete_word (buf, buf_end, buf_ptr);
				insert_chars (buf_end, buf_ptr);
				cur_col = cur_col_save;
				break;
			case '\n':
			case '\r':
				putchar('\r');
				putchar('\n');
#ifdef	BUF_DEBUG
printf ("Return with c_b:  %d.\n", current_buf);
#endif
				return(0);
			default:
				break;
		}
	typed = Getchar () & 0177;	/* only take 7 bits */
	}
}


int
delete_char (buf_end, buf_ptr)
register char *buf_end;
register char *buf_ptr;
{
	register char *tmp_ptr = buf_ptr + 1;
	register uint cnt = 0;

	/*
	**	move bytes in buffer, concatenating at current address
	**	reprint the line on the console, count number of bytes 
	**	to backup cursor and buf_ptr
	*/

	while (*buf_ptr && buf_ptr < buf_end) { 
		*buf_ptr++ = *tmp_ptr++;
		if (*buf_ptr)
			putchar(*buf_ptr);
		else
			putchar(' ');
		cnt++;
	}
	
	while (cnt--) {
		putchar('\b');
		buf_ptr--;	/* not necessary, but return ptr to orig val */
	}
	
	return(0);
}

int
insert_chars (buf_end, buf_ptr)
register char *buf_end;
register char *buf_ptr;
{
	register uint limit;
	register uint cnt = 0;
	register uint added = 0;
	register char typed;
	register char *string_end = buf_ptr;
	register char *tmp_ptr = buf_ptr;
	register char *save_ptr = buf_ptr;

	while (*string_end++);			/* Find current NULL */

	limit = (unsigned)buf_end - (unsigned)string_end - 1;/* room for NULL */

	typed = Getchar () & 0177;	/* get first inserted character */

	while (typed != ESCAPE && typed != '\n' && typed != '\r' && limit--) {
		
		if (typed == '\b') { 	/* no backspaces....sorry */
			limit++;
			continue; 
		}

		putchar(typed);		/* display inserted character */
		cur_col++;
		cnt = 0;

		tmp_ptr = buf_ptr;	/* Deal with the terminal */
		while (*tmp_ptr) {
			putchar(*tmp_ptr++);
			cnt++;
		}
		while (cnt--) 
			putchar('\b');

		added++;

		tmp_ptr = string_end + 1;
		save_ptr = tmp_ptr;		/* Deal with the buffer */
		while (string_end >= buf_ptr)
			*tmp_ptr-- = *string_end--;
		
		*buf_ptr = typed;
		buf_ptr++;
		string_end = save_ptr;

		typed = Getchar () & 0177;	/* only take 7 bits */
	}
	while (added--)
		putchar('\b');
	return(0);
}

int
delete_word (buf, buf_end, buf_ptr)
register char *buf;
register char *buf_end;
register char *buf_ptr;
{
	
	while (*buf_ptr != ' ' && *buf_ptr != '\t' && *buf_ptr) 
		delete_char (buf_end, buf_ptr);
	return(0);
}


move_command (limit, copy_buf_num)
uint	limit;
uint	copy_buf_num;
{
	
	register char  *copy_buf = cmd_buf[RELATIVE_BUF(copy_buf_num)];
	register char  *curr_buf = cmd_buf[RELATIVE_BUF(current_buf)];
	register uint  cnt;

	/*  put cursor in column 0  */
	if (cur_col)
		while (cur_col--)
			putchar('\b');

	/*  copy into cmd buffer, and display  */
	cnt = 0;
	while (*copy_buf) {
		*curr_buf = *copy_buf;
		putchar(*copy_buf); 
		copy_buf++;
		curr_buf++;
		cnt++;
	}

	/* NULL terminate cmd buf, fill the blanks */
	*curr_buf = '\0';
	for (; cnt != limit; cnt++) 
		putchar(' ');

	/* backup */
	for (cnt = 0; cnt != limit; cnt++) 
		putchar('\b');
	
	cur_col = 0;
	return;
}


