/*---------------------------------------------------------------------------
	diagnosctics.c

	only used in SPM_CONFIG product.
	calls all diag routine.
-----------------------------------------------------------------------------*/

#include "types.h"
#include "menu.h"

	int do_diag();
extern	int firstram();
extern	int disp_test();
extern	int pm20_test();

/* For now this menu structure is not used.
** 
** It is supposed to be called by the option 'diag' of the main menu.
** This menu will allow the user to re-run one or all of the diagnostic
** tests.
**
** For now we assume the main reason for a user to re-run the tests is to
** see again the eventual error messages. Since the tests disable and
** take out of the bdhere structure the bad board that it encounter, we
** have to reset this structure for the re-run. Once this issue is settled
** (and the code cleaned up) we can re-consider using the menu.
*/
struct init_menu i_diagnostics [] = {

	"all", "",
	"Run all Diagnostics",'c',0,0,do_diag, (char *)0,

	"mm", "",
	"Run Memory Diagnostics",'c',0,0,firstram, (char *)0,

	"disp", "",
	"Run Interrupt Dispatcher Diagnostics",'c',0,0,disp_test, (char *)0,

	"pm", "",
	"Run PM20 Diagnostics",'c',0,0,pm20_test, (char *)0,

	"", "", "", '\0', 0, 0, 0, (char *)0,
};



/*
** test routines
*/

do_diag()
{
	printf("\rRunning a few diagnostics ...\n");

	firstram();		/* memory test */
	disp_test();		/* interrupt dispatcher test */
	pm20_test();		/* pm20 test */

/*	printf("\rSizing memory.                  ");
	sizemem(0);

	printf("\rTesting the IOPM boards.        ");
	iopmtest();

	printf("\rTesting IOM                     ");
	iomtest();

	printf("\rTesting IOA                     ");
	ioatest();

	printf("\rTesting IOSBA                   ");
	iosbatest();
*/
}
