/* console routines for the cpu32 on board ascc */

#include "types.h"
#include "spm.h"
#include "ascc.h"
#include "misc.h"
#include "globl.h"
#include "rwi.h"
#include "rwicio.h"
#define CTL_Q 0x11
#define CTL_S 0x13

extern  uchar	modem_on;
extern  uchar    printer_on;
extern  char lastchar;
extern  char escflag;	/* ok.. if press's escape, use this. */


#ifdef	NO_MODEM
con_out (c)
char c;
{
	register struct ascc *asccaptr = AUXASCC0A;

	   /* Wait for transmitter(s) empty */
	while(!(asccaptr->reg[0].reg & RR0_TX) && 
				(asccaptr->reg[0].reg & RR0_DCD))
		;
	asccaptr->reg[8].reg = c;

#ifdef	PRINTER
	if(printer_on)	/* if printing as well.. */
		prt_out(c);	/* send to printer. */
#endif
}
#endif

#ifdef	NO_MODEM
con_in()
{
	register struct ascc *asccaptr = AUXASCC0A;
	register unsigned i;

	if(asccaptr->reg[0].reg & RR0_RX) {
		i=asccaptr->reg[8].reg;
		lastchar = i;
	}
	else
		i = -1;	
	return(i);
}
#endif

con_out (c)
char c;
{
	register struct ascc *CONSOLE = AUXASCC0A;
	register struct ascc *MODEM = AUXASCC0B;
	register struct ascc *PRINTER = AUXASCC1A;

	   /* Wait for transmitter(s) empty */
	while(!(CONSOLE->reg[0].reg & RR0_TX)) ;

	while (modem_on && !(MODEM->reg[0].reg & RR0_TX)) ;
	
	while (printer_on && !(PRINTER->reg[0].reg & RR0_TX)) ;

	if (CONSOLE->reg[0].reg & RR0_DCD)
		CONSOLE->reg[8].reg = c;

	if (modem_on && (MODEM->reg[0].reg & RR0_DCD))
		MODEM->reg[8].reg = c;

	if (printer_on && (PRINTER->reg[0].reg & RR0_DCD)) 
		PRINTER->reg[8].reg = c;
}


con_in()
{
	register struct ascc *CONSOLE = AUXASCC0A;
	register struct ascc *MODEM = AUXASCC0B;
	register struct ascc *PRINTER = AUXASCC1A;
	register int c = -1;

	/* check to see if the modem port is ready */
#ifdef	REMOVE
	modem_on = (MODEM->reg[0].reg & RR0_DCD);
#endif
	if(CONSOLE->reg[0].reg & RR0_RX) {
		c = CONSOLE->reg[8].reg;
		lastchar = c;
	}
	else {
		if (modem_on && (MODEM->reg[0].reg & RR0_RX)) {
			c = MODEM->reg[8].reg;
			lastchar = c;
		}
	}
	return(c);
}

Getchar() /* this is used when MACRO buffer input is allowed as well. */
{
	register char c;

	/*  The following line fails lint: nonportable char comparison */
	while((c = con_in()) == -1); /* else, wait for one from keyboard.*/
	return(c);
}

Putchar(c)
register char c;
{
	char in1;

	if (c != ESCAPE)
	{
		in1 = con_in(); /* get a character.. */
		if(in1 == ESCAPE)	{ /* if escaped.. */
			escflag=1;	/* show it was pressed... */
		}

		if(in1==CTL_S)	/* if pausing. */
			getchar(); /* wait until get another char.. */
		con_out (c);
		if (c == '\n')	/* if line feed, send return.. */
			con_out ('\r');
	}
	return;
}

ifesc() /* check for exit command.. yes? */
{

	if(escflag) {	/* if one was pressed.. */
	
		escflag=0;	/* clear it. */
		return(1);	/* show it. */
	}

	if(con_in() == ESCAPE) {  /* if escape char. */
		return(1);
	}
	return(0);
}
	
