
#-------------------------------------------------------------------------------
#	filename : spmfw.make
#-------------------------------------------------------------------------------

FMON	= config

SGS	=	/home/hanna/eddie/hanna/sgs/4.24
#SGS	=	$(SGS_ROOT)

CC	=	$(SGS)/bin/cc
AS	=	$(SGS)/bin/as
LD	=	$(SGS)/bin/ld

COMMONOBJ = \
	startup.o spmscb.o vector.o Out.o ml_util.o \
	new_start.o main.o poll.o pollio.o localmenu.o menu.o localvars.o \
	adc.o boot.o boot_path.o cab_temp.o console.o debug.o devreq.o \
	dtreq.o edit.o help.o int_disp.o iopm.o iosba.o ipcc.o locram.o \
	margin.o memtools.o monitor.o nothing.o fslot.o \
	nov_chk.o nov_init.o nov_util.o novtst.o \
	other.o parse.o periph.o printf.o rwi.o rwiad.o rwicio.o rwiscc.o \
	rwi_test.o sbus.o spm_ad.o switches.o sprintf.o util.o

CONFIGOBJ = \
	image.o \
	excpt_config.o config_poll.o confi_pollio.o \
	diagnostics.o disp_test.o mem_test.o pm20_test.o \
	fix_it.o

SINC = ./head

#option for cc --- change all .data's to .text for prom resident code
NODATA = -Wa,-r

#option for cc --- do not generate stack probe code
NSPROB = -W0,-sp

#options for cc --- search this directory for include files before /usr/include
CFLAG = -YI,$(SINC) -DSPM_CONFIG -O
CFLAG_NO_OPT = -YI,$(SINC) -DSPM_CONFIG 
AFLAG = -n
M4FLAG = -m 

all install default reprod:	$(FMON)

submit:	$(FMON)_sub

$(FMON):	$(SINC)/spm.h date_sub.o ldrepfile \
		$(COMMONOBJ) $(CONFIGOBJ)
		$(LD) -o $(FMON).r -m ldrepfile \
		$(COMMONOBJ) $(CONFIGOBJ) date_sub.o > $(FMON).map
		nm -xev $(FMON).r | sort +1.0b -1.11b > map
		cp $(FMON).r $(FMON)
		strip $(FMON)
		sort map > map1
		size -x $(FMON)

$(FMON)_sub:	$(SINC)/spm.h date.o ldfile \
		$(COMMONOBJ) $(CONFIGOBJ)
		$(LD) -o $(FMON).r -m ldfile \
		$(COMMONOBJ) $(CONFIGOBJ) date.o > $(FMON).map
		nm -xev $(FMON).r | sort +1.0b -1.11b > map
		cp $(FMON).r $(FMON)
		strip $(FMON)
		sort map > map1
		size -x $(FMON)
		mv date.c date_sub.c

clean:
	rm -f $(COMMONOBJ) $(CONFIGOBJ) date.o 
	rm -f $(SINC)/spm.h $(SINC)/loc_routines.h

clobber: clean
	rm -f map map1 $(FMON).map $(FMON).r $(FMON) tags 

cldate:	clobber
	rm -f $(FMON)_sub date.*

download:
	umodem -st $(FMON).tek

.c.s:
	$(CC) -S $(CFLAG) $(NSPROB) $<
	grep -v "^	fmovm" $@ > temp.s
	mv temp.s $@

.c.o:
	$(CC) -S $(CFLAG) $(NSPROB) $<
	grep -v "^	fmovm" $*.s > temp.s
	mv temp.s $*.s
	$(AS) $(AFLAG) $*.s
	rm $*.s

.c.list:
	$(CC) -S $(CFLAG) $(NSPROB) $*.c
	grep -v "^	fmovm" $*.s > temp.s
	mv temp.s $*.s
	$(AS) $(AFLAG) -K $*.s
	rm $*.s

.s.list:
	$(AS) $(AFLAG) -K $*.s

$(SINC)/loc_routines.h:	$(SINC)/loc_rout.h
	cp $(SINC)/loc_rout.h $(SINC)/loc_routines.h

date.c: $(COMMONOBJ) $(CONFIGOBJ)
	echo "char *date[] = \"\\\r\\\n`date`\\\r\\\n\";" > date.c

adc.o:	$(SINC)/novram.h \
		$(SINC)/spm.h \
		$(SINC)/rwi.h

cmds.o:		$(SINC)/types.h \
        	$(SINC)/globl.h \
        	$(SINC)/global.h \
		$(SINC)/spm.h \
		$(SINC)/iom.h \
		$(SINC)/menu.h \
		$(SINC)/loc_routines.h \
		$(SINC)/routines.h \
		$(SINC)/disp.h

rwi.o:		$(SINC)/spm.h \
		$(SINC)/types.h \
		$(SINC)/menu.h \
		$(SINC)/novram.h \
		$(SINC)/ring.h \
		$(SINC)/loc_routines.h \
        	$(SINC)/global.h \
        	$(SINC)/globl.h 

rwi_test.o:	$(SINC)/rwi.h \
		$(SINC)/spm.h \
		$(SINC)/rwicio.h \
		$(SINC)/novram.h \
		$(SINC)/rtc.h

rwiad.o:	$(SINC)/rwi.h \
		$(SINC)/rwiad.h \
		$(SINC)/novram.h \
		$(SINC)/spm.h \
		$(SINC)/rwicio.h

rwicio.o:	$(SINC)/rwi.h \
		$(SINC)/novram.h \
		$(SINC)/rwicio.h

rwiscc.o:	$(SINC)/rwi.h \
		$(SINC)/rwiscc.h

console.o:	$(SINC)/spm.h \
		$(SINC)/ascc.h \
		$(SINC)/misc.h \
		$(SINC)/globl.h

pollio.o:	$(SINC)/spm.h \
		$(SINC)/types.h \
		$(SINC)/vac.h \
		$(SINC)/menu.h \
		$(SINC)/icb.h \
		$(SINC)/icb_config.h 

debug.o:	$(SINC)/types.h \
		$(SINC)/menu.h \
		$(SINC)/loc_routines.h \
		$(SINC)/routines.h \
		$(SINC)/spm.h \
		$(SINC)/rtc.h \
		$(SINC)/global.h \
		$(SINC)/globl.h \
		$(SINC)/disp.h \
		$(SINC)/ipcc.h 

dnld.o:		$(SINC)/misc.h \
		$(SINC)/spm.h \
		$(SINC)/ascc.h \
		$(SINC)/a.out.h \
		$(SINC)/global.h \
		$(SINC)/types.h \
		$(SINC)/filehdr.h \
		$(SINC)/scnhdr.h \
		$(SINC)/aouthdr.h

locram.o:	$(SINC)/spm.h \
		$(SINC)/types.h

dram.o:		$(SINC)/misc.h \
		$(SINC)/globl.h \
		$(SINC)/spm.h \
		$(SINC)/rwicio.h

mem.o:		$(SINC)/spm.h \
		$(SINC)/types.h

ckiomerr.o:	$(SINC)/types.h \
		$(SINC)/spm.h \
		$(SINC)/global.h \
		$(SINC)/iom.h

pollcss.o:	$(SINC)/global.h \
		$(SINC)/types.h \
		$(SINC)/disp.h \
		$(SINC)/spm.h

fslot.o:	$(SINC)/disp.h

excpt_prom.o:	$(SINC)/misc.h \
		$(SINC)/spm.h \
		$(SINC)/types.h \
		$(SINC)/rwicio.h \
		$(SINC)/ascc.h \
		$(SINC)/globl.h \
		$(SINC)/bus.h \
		$(SINC)/ring.h

localmenu.o:	$(SINC)/types.h \
		$(SINC)/menu.h \
		$(SINC)/loc_routines.h \
		$(SINC)/routines.h

main_prom.o:	$(SINC)/misc.h \
		$(SINC)/globl.h \
		$(SINC)/spm.h \
		$(SINC)/version.h \
		$(SINC)/rwicio.h

menu.o:		$(SINC)/types.h \
		$(SINC)/menu.h \
		$(SINC)/loc_routines.h \
		$(SINC)/routines.h \
		$(SINC)/globl.h \
		$(SINC)/global.h

monitor.o:	$(SINC)/types.h \
		$(SINC)/menu.h \
		$(SINC)/global.h \
		$(SINC)/loc_routines.h \
		$(SINC)/routines.h

parse.o:	$(SINC)/types.h \
		$(SINC)/menu.h \
		$(SINC)/global.h

periph.o:	$(SINC)/misc.h \
		$(SINC)/spm.h \
		$(SINC)/ascc.h \
		$(SINC)/rwicio.h \
		$(SINC)/globl.h

powerup.o:	$(SINC)/misc.h \
		$(SINC)/globl.h \
		$(SINC)/novram.h \
		$(SINC)/spm.h \
		$(SINC)/rwicio.h

smfd.o:		$(SINC)/portable.h \
		$(SINC)/smfd.h
		$(CC) -S $(CFLAG_NO_OPT) $(NSPROB) smfd.c
		grep -v "^	fmovm" smfd.s > temp.s
		mv temp.s smfd.s
		$(AS) $(AFLAG) smfd.s
		rm smfd.s

smxfer.o:
		$(AS) $(AFLAG) smxfer.s

fdiag.o:	$(SINC)/types.h \
		$(SINC)/menu.h \
		$(SINC)/global.h \
		$(SINC)/loc_routines.h \
		$(SINC)/routines.h \
		$(SINC)/floppy.h
		$(CC) -S $(CFLAG_NO_OPT) $(NSPROB) fdiag.c
		grep -v "^	fmovm" fdiag.s > temp.s
		mv temp.s fdiag.s
		$(AS) $(AFLAG) fdiag.s
		rm fdiag.s

switches.o:	$(SINC)/misc.h \
		$(SINC)/spm.h \
		$(SINC)/version.h \
		$(SINC)/global.h

devreq.o:	$(SINC)/icb.h \
		$(SINC)/vreg.h \
		$(SINC)/icb_config.h \
           	$(SINC)/rtb.h 
		$(CC) -S $(CFLAG) $(NSPROB) devreq.c
		grep -v "^	fmovm" devreq.s > temp.s
		mv temp.s devreq.s
		$(AS) $(AFLAG) devreq.s
		rm devreq.s

dtreq.o:
		$(CC) -S $(CFLAG) $(NSPROB) dtreq.c
		grep -v "^	fmovm" dtreq.s > temp.s
		mv temp.s dtreq.s
		$(AS) $(AFLAG) dtreq.s
		rm dtreq.s

boot.o:		$(SINC)/icb.h \
		$(SINC)/spm.h \
		$(SINC)/devcmd.h \
		$(SINC)/vreg.h \
		$(SINC)/icb_config.h \
		$(SINC)/rtb.h \
		$(SINC)/globl.h \
		$(SINC)/global.h \
		$(SINC)/sa_dir.h \
		$(SINC)/misc.h \
		$(SINC)/novram.h \
		$(SINC)/disp.h
		$(CC) -S $(CFLAG_NO_OPT) $(NSPROB) boot.c
		grep -v "^	fmovm" boot.s > temp.s
		mv temp.s boot.s
		$(AS) $(AFLAG) boot.s
		rm boot.s

edt.o:		$(SINC)/icb.h \
		$(SINC)/spm.h \
		$(SINC)/devcmd.h \
		$(SINC)/vreg.h \
		$(SINC)/icb_config.h \
		$(SINC)/rtb.h \
		$(SINC)/misc.h \
		$(SINC)/disp.h

util.o:		$(SINC)/global.h \
		$(SINC)/loc_routines.h \
		$(SINC)/routines.h

novtst.o:	$(SINC)/spm.h \
		$(SINC)/novram.h \
		$(SINC)/types.h

nov_util.o:	$(SINC)/spm.h \
		$(SINC)/novram.h \
		$(SINC)/types.h \
		$(SINC)/disp.h \
		$(SINC)/ioa0.h \
		$(SINC)/icb.h \
		$(SINC)/icb_config.h \
		$(SINC)/rwi.h \
		$(SINC)/globl.h \
		$(SINC)/global.h

nov_init.o:	$(SINC)/spm.h \
		$(SINC)/novram.h \
		$(SINC)/types.h \
		$(SINC)/disp.h \
		$(SINC)/ioa0.h \
		$(SINC)/icb.h \
		$(SINC)/icb_config.h \
		$(SINC)/rwi.h \
		$(SINC)/globl.h \
		$(SINC)/global.h

nov_chk.o:	$(SINC)/spm.h \
		$(SINC)/novram.h \
		$(SINC)/types.h \
		$(SINC)/disp.h \
		$(SINC)/ioa0.h \
		$(SINC)/icb.h \
		$(SINC)/icb_config.h \
		$(SINC)/rwi.h \
		$(SINC)/globl.h \
		$(SINC)/global.h

iosba.o:	$(SINC)/afifo.h \
		$(SINC)/iosba_addr.h

polliobus.o:	$(SINC)/iosba_addr.h 

$(SINC)/spm.h: $(SINC)/spm.h.doc
	echo "/*DO NOT EDIT THIS FILE! EDIT spm.h.doc INSTEAD!!!*/" > $(SINC)/spm.h
	grep "^#define" $(SINC)/spm.h.doc >> $(SINC)/spm.h

flp_xfer.o:
	$(AS) $(AFLAG) $(M4FLAG) $*.s

Out.o:
	$(AS) $(AFLAG) $(M4FLAG) $*.s

spmscb.o:
	$(AS) $(AFLAG) $(M4FLAG) $*.s

vector.o:
	$(AS) $(AFLAG) $(M4FLAG) $*.s

startup.o:
	$(AS) $(AFLAG) $(M4FLAG) $*.s

ml_util.o:
	$(AS) $(AFLAG) $(M4FLAG) $*.s

prom.o:
	$(AS) $(AFLAG) $(M4FLAG) $*.s

image.o:
	$(AS) $(AFLAG) $(M4FLAG) $*.s

pow_up_tst.o:
	$(AS) $(AFLAG) $(M4FLAG) $*.s
