
#include "types.h"
#include "spm.h"
#include "rwiad.h"

temp()
{
	register ushort result,i;
	register loc_temp;
	register volts;

	*ADC_CNTL = ADC_SC | ADC_CH7;
	for(i=0 ; i<=0x1000; i++) {
		result = *(ushort *)ADC_ADATA;
		if(result & ADC_EOC)
			break;
	}
	if(i==0x1000)
		printf("\nUnsuccessful A/D conversion on channel 7\n");
	else {
		loc_temp = *ADC_ADATA & 0x00ff;
		volts = (loc_temp * 10000) * 176;	/* no floating point */
		loc_temp = ((volts - 300) / 703);
		volts = loc_temp/10000;	/* and make it an int again. */
		printf("\nCard cage temperature = %02d degrees Celsius\n",
									volts); 
	}
}			

