
#include "types.h"
#include "disp.h"
#include "sa_dir.h"
#include "dev.h"
#include "icb.h"
#include "spm.h"
#include "icb_config.h"
#include "globl.h"

#define Sbus_Num_Slot		16
#define BAD_BOOT_TYPE		(uint)0
#define ICB_BOOT_TYPE		(uint)1
#define IOPM_BOOT_TYPE		(uint)2

void	get_device_info();
void	display_help_message ();
uint	check_boot();

extern	uint  iopm_bootable();

extern	uchar	bdhere [];
extern  struct  icb_config	io_conf[][MAXSLOTS];
extern	struct	iosb_config	ios_conf[][MAX_CSS_SLOT];
extern	uchar	css_slot;
extern	uchar	sub_slot;
extern	uchar	phys_dev;
extern	uchar	log_dev;
extern	uint	boot_type;

/* global variable(s) only used by "boot.c and "boot_path.c" */
char	filename[MAX_DIR_NAME];
struct	icb_config	*icb_ptr;

void
get_device_info(str)
char	*str;
{
	uint	boot_flag;

	filename[0] = '\0';
	css_slot = 0;
	sub_slot = NO_SUB_SLOT;
	phys_dev = 0;
	log_dev = 0;
	boot_type = DV_NO_DEV;
	icb_ptr = (struct icb_config *)0;

	if (*str == '?') {
		boot_type = DV_HELP_REQUEST;
		return;
	}

	if (str[0] == 'f' && str[1] == 'l' && 
				str[2] == 'p' && str[3] == '/') {
		boot_type = DV_FLP;
		str +=4;		/* skip f-l-p-/ */
		strcpy (filename, str); /* copy filename */
		return;
	}
	
	if (!isdigit(*str)) {

		printf("Incorrect device specification %s\n",str);
		boot_type = DV_NO_DEV;
		return;
		
	}

	css_slot = (uchar)atoi(str);
	if (css_slot >= Sbus_Num_Slot) {
		printf("Invalid CSS slot number %x (%d)\n", css_slot, css_slot);
		boot_type = DV_NO_DEV;
		return;
	}

	while (isdigit(*str))
		++str;

	if (*str == '/') {
		str++;
		if (isdigit (*str)) {
			sub_slot = (uchar)atoi(str);
			while (isdigit(*str))
				++str;
		}
		else {
			printf ("Illegal subslot specification - not a digit\n");
			boot_type = DV_NO_DEV;
			return;
		}
	}
	else {
		sub_slot = NO_SUB_SLOT;
	}

	boot_flag = check_boot ();

	if (boot_flag == BAD_BOOT_TYPE) {
		boot_type = DV_NO_DEV;
		return;
	}


	switch (*str) {
	case 'm':
	case 'n':
		if (boot_flag == IOPM_BOOT_TYPE)
			boot_type = (*str == 'm') ? DV_IOPM_MT : DV_IOPM_9T;

		if (boot_flag == ICB_BOOT_TYPE)
			boot_type = (*str == 'm') ? DV_MT : DV_9T;

		if (*++str != 't') {
			printf("Incorrect tape device specification %s\n",str);
			boot_type = DV_NO_DEV;
			return;
		}

		str++;
		if (isdigit (*str)) {
			phys_dev = (uchar)atoi(str);
			while (isdigit (*str))
				++str;
		}

		break;
	case 'd':
		str++;
		if (isdigit (*str)) {
			phys_dev = (uchar)atoi(str);

			while (isdigit(*str))
				str++; 
		}
		else {
			printf ("Illegal drive number - not a digit\n");
			boot_type = DV_NO_DEV;
			return;
		}

		if (boot_flag == IOPM_BOOT_TYPE) {

			if (str[0] == 's' && isdigit (str[1])) {
				log_dev = (uchar)atoi(++str);
				while (isdigit(*str))
					str++;
			
				boot_type = DV_IOPM_DK;
			}
			else {
				boot_type = DV_IOPM_RV;
			}
		}

		if (boot_flag == ICB_BOOT_TYPE)
			boot_type = DV_RV;
		break;
	default : 
		printf("Incorrect device specification %s\n",str);
		boot_type = DV_NO_DEV;
		return;

	}
	strcpy (filename, str);
	return;
}

static char *help_message[] = {
"   X/Ymt[#]file | X/Ynt[#]file | X/Yd#file | X/Yd#s#file | flp/file; where",
"   X = CSS slot (IOM or IOPM)",
"   Y = sub-slot (EDT or SCSI or IOPM)",
"   mt - archive; nt - nine track; d# - disk reserved; d#s# - disk slice",
"   flp/ - indicates floppy boot device",
"   Note:  \"/Y\" is null for an IOPM in the CSS",
"\n   Use the 'show' command to display system configuration",
""
} ;

void
display_help_message()
{
	int i = 0;

	printf("\n");
	while (*help_message[i]) {
		printf(help_message[i++]);
		printf("\n");
	}
	printf("\n");
	return;
}

uint
check_boot ()
{
	/* uint	boot_flag = BAD_BOOT_TYPE; */
	register uint	id;
	register uint	iom_num;

	if (sub_slot == NO_SUB_SLOT) {

		if ((bdhere[css_slot] & BDTYPEMASK) == IOPTYPE) {

			if (iopm_bootable (css_slot, sub_slot)) {
				return(IOPM_BOOT_TYPE);
			}
			else {
				printf ("IOPM in slot %x (%d) not bootable.\n",
					css_slot, css_slot);
				return(BAD_BOOT_TYPE);
			}
		}
		else {
			printf ("IOPM boot selected, no IOPM in slot: %x (%d)\n",
				css_slot, css_slot);
			return(BAD_BOOT_TYPE);
		}
	}

	if ((bdhere[css_slot] & BDTYPEMASK) != IOMTYPE) {
		printf ("IOM boot selected, no IOM in slot %x (%d).\n", 
				css_slot, css_slot);
		return(BAD_BOOT_TYPE);
	}

	iom_num = logiom(css_slot);

	if (ios_conf[iom_num][sub_slot].slot_id == IOPHERE) {
		if (iopm_bootable (css_slot, sub_slot)) {
			return(IOPM_BOOT_TYPE);
		}
		else {
			printf ("IOPM in %x/%x (%d/%d) not bootable.\n", 
				css_slot, sub_slot, css_slot, sub_slot);
			return(BAD_BOOT_TYPE);
		}
	}

	if ((id=io_conf[iom_num][sub_slot].icb_slot_id) == EDT || id == SCSI) {
		icb_ptr = &io_conf[iom_num][sub_slot];
		return(ICB_BOOT_TYPE);
	}

	printf ("Boot path indicates IOM/controller type boot,\n");
	printf ("No I/O controller in sub-slot %x/%x (%d/%d).\n",
		css_slot, sub_slot, css_slot, sub_slot);
	return(BAD_BOOT_TYPE);
}

