include(./head/top.h)

global ByteOut
global WordOut
global LongOut

#-------------------------------------------------------------------------------
# ByteOut : Output a binary byte value
#
#	entry: %d0 = byte value
#	exit:  none
#-------------------------------------------------------------------------------
ByteOut:
	movm.l	&D0S+D1S+A0S,-(%sp)	# Save the registers
	lea.l	Digits,%a0		# Point to the digits
	mov.b	%d0,%d1			# Save the number
	lsr.b	&0x04,%d0		# Shift the byte
	and.w	&0x000f,%d0		# Mask off
	mov.b	0(%a0,%d0.w),%d0	# Get the character
	jsr		Print
	and.w	&0x000f,%d1		# Mask off
	mov.b	0(%a0,%d1.w),%d0	# Get the character 
	jsr		Print		# Print the byte
	movm.l	(%sp)+,&D0R+D1R+A0R	# Restore the registers
	rts

#-------------------------------------------------------------------------------
# WordOut : Output a binary word value
#
#	entry: %d0 = word value
#	exit:  none
#-------------------------------------------------------------------------------
WordOut:
	movm.l	&D0S+D1S+D3S+A0S,-(%sp)	# Save the registers
	lea.l	Digits,%a0		# Point to the digits
	mov.w	%d0,%d1			# Save the number
	mov.b	&0x04,%d3		# Set the loop count
WO1:
	rol.w	&0x04,%d1		# Move the upper nibble into place
	mov.b	%d1,%d0			# Get the nibble
	and.w	&0x000f,%d0		# Mask it
	mov.b	0(%a0,%d0.w),%d0	# Get the character
	jsr		Print		# Print the byte
	sub.b	&0x01,%d3		# Decrement the counter
	tst.b	%d3			# End of count?
	bne.b	WO1			# Loop back for whole word
	movm.l	(%sp)+,&D0R+D1R+D3R+A0R	# Restore the registers
	rts

#-------------------------------------------------------------------------------
# LongOut : Output a binary long word value
#
#	entry: %d0 = long word
#	exit:  none
#-------------------------------------------------------------------------------
LongOut:
	movm.l	&D0S+D1S+D3S+A0S,-(%sp)	# Save the registers
	lea.l	Digits,%a0		# Point to the digits
	mov.l	%d0,%d1			# Save the number
	mov.b	&0x08,%d3		# The loop count
LO1:
	rol.l	&0x04,%d1		# Move the upper nibble
	mov.b	%d1,%d0			# Get the nibble
	and.w	&0x000f,%d0		# Mask off the junk
	mov.b	0(%a0,%d0.w),%d0	# Get the character
	jsr		Print		# Print the byte
	sub.b	&0x01,%d3		# Decrement the count
	tst.b	%d3			# The end?
	bne.b	LO1			# Skip if no
	movm.l	(%sp)+,&D0R+D1R+D3R+A0R	# Restore
	rts
Digits:
	byte	'0,'1,'2,'3,'4,'5,'6,'7,'8,'9,'A,'B,'C,'D,'E,'F,NULL
