/*
    Copyright 1982
    Alcyon Corporation
    8716 Production Ave.
    San Diego, Ca.  92121

    @(#)symt.c	2.6 11/20/84
*/

/**
 * symbol table entry allocation and lookup routines
**/

#include "parser.h"

#define STEL    HSIZE/2

#ifndef SYM_TO_DSK
    struct symbol *symtab[HSIZE];   /*hash table*/
    struct symbol *sym_ent = 0;     /*pointer to next avail symbol buf*/
#endif

#ifndef LNG_NMS
#   define ULAB_MSG "undefined label: %.8s"
#   define USTR_MSG "undefined structure data type: %.8s"
#   define NPRM_MSG "not in parameter list: %.8s"
#else
#   define ULAB_MSG "undefined label: %s"
#   define USTR_MSG "undefined structure data type: %s"
#   define NPRM_MSG "not in parameter list: %s"
#endif


/**
 * syminit - initialize the symbol table, install reswords
 *      Goes thru the resword table and installs them into the symbol
 *      table.
**/
syminit()                           /* returns - none*/
{
    register struct resword *rp;

#ifdef SYM_TO_DSK
    install("",0,0);    /* null entry at zero */
#endif
    for( rp = &reswords[0]; rp->r_name != 0; rp++ )
        install(rp->r_name,SRESWORD|SDEFINED,rp->r_value);
}

#ifndef SYM_TO_DSK

struct symbol *salloc();

/**
 * install - install a symbol in the symbol table
 *      Allocates a symbol entry, copies info into it and links it
 *      into the hash table chain.
**/
char *
install(sym,attrib,offset)          /* returns pointer to symbol struct*/
char *sym;                          /* symbol to install*/
int attrib;                         /* attribues of symbol*/
int offset;                         /* symbol offset (resword value)*/
{
    register struct symbol *sp;
    register short i, is;

    sp = salloc(sym);
    is = in_struct;
    sp->s_attrib = attrib;
    sp->s_offset = offset;
    sp->s_sc = sp->s_type = sp->s_dp = sp->s_ssp = 0;
    sp->s_sib = sp->s_child = sp->s_par = 0;
    if (is) {
        sp->s_par = struc_parent[is];
        hold_sib = struc_sib[is];
        sp->s_scope = (infunc) ? FUNC_SCOPE : GLOB_SCOPE;       /* [vlh] 4.2 */
        if (struc_sib[is])
            struc_sib[is]->s_sib = sp;
        else
            struc_parent[is]->s_child = sp;
        struc_sib[is] = sp;
#ifdef DEBUG
    if (symdebug) 
        putheir(sp);
#endif
    }
    else
        sp->s_scope = scope_level;          /* [vlh] 4.2 */

    i = symhash(sym,is|smember);        /*link into chain list*/
    sp->s_next = symtab[i];
    symtab[i] = sp;
    return((char *)sp);
}

/**
 * salloc - allocate symbol table entry storage
**/
struct symbol *
salloc(sym)
char *sym;
{
    register struct symbol *sp;
    register int i;

    if ((sp = sym_ent) == 0) {
#ifndef LNG_NMS
        if ((sp = sbrk(SYME_NUM * sizeof(struct symbol))) == -1)
#else
        if ((sp = malloc(SYME_NUM * sizeof(struct symbol))) == 0)
#endif
            ferror("symbol table overflow");

        for (i = SYME_NUM-1; --i != -1; ) {
            if (sp <= 0)
                ferror("bad symbol table");
            sp->s_next = sym_ent;
            sym_ent = sp++;
        }
    }
    else
        sym_ent = sp->s_next;
    
#ifdef LNG_NMS
    i = strlen(sym) + 1;
    sp->s_symbol = malloc(i);
    if ((sp->s_symbol = malloc(i)) == 0)
        ferror("symbol table overflow");
#endif
    symcopy(sym,sp->s_symbol);          /*copy symbol to symbol struct*/
    return(sp);
}

/**
 * lookup - looks up a symbol in symbol table
 *      Hashes symbol, then goes thru chain, if not found, then
 *      installs the symbol.
**/
char *
lookup(sym,force)           /* returns pointer to symbol buffer*/
char *sym;                  /* pointer to symbol*/
int force;                  /* [vlh] 4.2 force entry in symbol table */
{
    register struct symbol *sp, *hold;
    register char *p;
    short exact, prev_level;        /* same name, diff type or offset */

    p = sym; prev_level = 0;
    for( sp = symtab[symhash(p,0)]; sp != 0; sp = sp->s_next )
        if((sp->s_attrib&(SRESWORD|STYPEDEF)) && symequal(p,sp->s_symbol))
            return(sp);
    hold = 0;
#ifdef DEBUG
        if (symdebug)
            printf("looking up [%s]\n",p);
#endif
    if (!(smember|in_struct)) { /*[vlh]*/
        for( sp=symtab[symhash(p,0)]; sp!=0; sp=sp->s_next ) {
            if(symequal(p,sp->s_symbol)) {
                if (scope_level == sp->s_scope) /* [vlh] 4.2 added scope... */
                    return(sp);                 /* perfect scope match */
                else
                    if (!force && prev_level <= sp->s_scope) {
                        hold = sp;
                        prev_level = sp->s_scope;
                    }
            }
        }
        if (hold) /* [vlh] 4.2 added scope... */
            return(hold);
    }
    else {  /* doing a declaration or an expression */
        exact = 0;
        for (sp=symtab[symhash(p,in_struct|smember)]; sp!=0; sp=sp->s_next) {
            if (symequal(p,sp->s_symbol)) {
                if (symsame(sp,hold,&exact))
                    return(sp);
                else if (!hold && !exact) 
                    hold = sp;
            }
        }   /* For Loop */
        if (hold && (instmt || in_struct==0 || smember!=0)) { /*4.1*/
#ifdef DEBUG
            if (debug && instmt)
                warning("inexact structure field match");
#endif
            return(hold);
        }
    }
#ifdef DEBUG
#ifndef LNG_NMS
    if (symdebug) printf("installing [%.8s] %d\n",p,indecl);
#else
    if (symdebug) printf("installing [%s] %d\n",p,indecl);
#endif
#endif
    return(install(p,0,0));
}

/**
 * freesyms - frees all local symbols at end of function declaration
 *      Searches thru symbol table, deleting all symbols marked as locals
**/
freesyms(level)                         /* returns - none*/
int level;                              /* [vlh] 4.2 scope levels... */
{
    register short i;
    register struct symbol *sp, *tp, *nextp, **htp;

    for (htp = &symtab[0], i = HSIZE; --i >= 0; htp++)
        for (tp = 0, sp = *htp; sp != 0; sp = nextp)  {
            nextp = sp->s_next;
            if (level == FUNC_SCOPE)
                if (!(sp->s_attrib&SDEFINED)) {
                    error(ULAB_MSG,sp->s_symbol);
                    sp->s_attrib |= SDEFINED;
                }
            if (sp->s_attrib & (SGLOBAL|SRESWORD) )
                tp = sp;
            else if  (!(sp->s_attrib & SGLOBAL) && sp->s_scope < level)
                tp = sp;
            else {
#ifdef DEBUG
    if (symdebug)
        printf("freeing %s, level %d\n",sp->s_symbol,level);
#endif
                if (sp->s_sc == REGISTER) { /* [vlh]4.6, restore regs */
                    if (SUPTYPE(sp->s_type))    /* POINTER => aregs */
                        naregs--;
                    else
                        ndregs--;
                }
                if ((BTYPE(sp->s_type)) == FRSTRUCT)
                    warning(USTR_MSG,frstab[sp->s_ssp]->s_symbol);
                if (tp)
                    tp->s_next = sp->s_next;
                else
                    *htp = sp->s_next;
                sp->s_next = sym_ent;
                sym_ent = sp;
                free(sp->s_symbol);
            }
        }
}

/**
 * chksyms - checks symbol table for undefined symbols, etc.
 *      Goes thru the symbol table checking for undeclared forward
 *      referenced structures, and outputs local symbols for debugger.
**/
chksyms(last)                       /* returns - none*/
int last;                           /* last check for undefined */
{
    register struct symbol **htp, *sp, *fp;
    register short i, sc;

    for( htp = &symtab[0], i = HSIZE; --i >= 0; htp++ )
        for( sp = *htp; sp != 0; sp = sp->s_next ) {
            sc = sp->s_sc;
            if(sc!=0 && sp->s_ssp>=0 && (BTYPE(sp->s_type))==FRSTRUCT) {
                fp = frstab[sp->s_ssp];
                if (dtab[fp->s_ssp]) {
#ifdef DEBUG
                    if (initdebug) {
                        printf("pre-frstruct: ");
                        if (sp->s_par)
                            printf("p [%s], ",sp->s_par->s_symbol);
                        else
                            printf("no par, ");
                        if (fp->s_child) {
                            printf("frc [%s], ",fp->s_child->s_symbol);
                            if (fp->s_child->s_par)
                            printf("frcp [%s], ",fp->s_child->s_par->s_symbol);
                            else
                                printf("no frcp, ");
                        }
                        else
                            printf("no frc, ");
                        if (sp->s_child)
                            printf("c [%s]\n",sp->s_child->s_symbol);
                        else
                            printf("no child\n");
                    }
#endif
                    sp->s_child = fp->s_child->s_par;
                    if ((sp->s_sc != STELCL && sp->s_sc != UNELCL)) /*4.7*/
                        sp->s_par = sp->s_child; /*[vlh]*/
#ifdef DEBUG
                    if (initdebug) {
                        printf("post-frstruct: ");
                        if (sp->s_par)
                            printf("p [%s], ",sp->s_par->s_symbol);
                        else
                            printf("no parent, ");
                        if (sp->s_child)
                            printf("c [%s]\n",sp->s_child->s_symbol);
                        else
                            printf("no child\n");
                    }
#endif
                    sp->s_ssp = fp->s_ssp;    /* 3.4 ssp>0 */
                    sp->s_type = (sp->s_type&~TYPE) | STRUCT; /* 4.2+ moved */
                    sp->s_scope = GLOB_SCOPE;	/* 4.9 */
                }
#ifndef NOWARN
                else if (last)
                    warning(USTR_MSG,fp->s_symbol);
#endif
            }
            if( sc == PDECLIST || sc == PDECREG ) {
                error(NPRM_MSG,sp->s_symbol);
                sp->s_sc = (sc == PDECLIST) ? AUTO : REGISTER;
            }
        }
}
#endif

/**
 * symhash - compute hash value for symbol
 *      Sums the symbols characters and takes that modulus the hash table
 *      size.
 *      [vlh] 4.3, symhash must be on minimum number of chars which is a max
 *          eg. Maximum number for external variable is SSIZE-1...
**/
symhash(sym,stel)                   /* returns hash value for symbol*/
char *sym;                          /* pointer to symbol*/
int stel;                           /* structure element flag*/
{
    register char *p;
    register short hashval, i;

    hashval = (stel ? STEL : 0 );
    for( p = sym, i = SSIZE-1; *p != '\0' && i > 0; i-- )
        hashval += *p++;
    return( hashval % HSIZE );
}

/**
 * symequal - check for symbol equality
 *      Does comparison between two symbols.
 *      [vlh] 4.3, global (external symbols) match at SSIZE-1!!!
**/
symequal(sym1,sym2)                 /* returns 1 if equal, 0 otherwise*/
char *sym1;                         /* pointer to first symbol*/
char *sym2;                         /* pointer to second symbol*/
{
    register char *p, *q;
    register short i;

    i = (scope_level == GLOB_SCOPE && !smember && !in_struct) ? SSIZE-1 : SSIZE;
    for( p = sym1, q = sym2; *p == *q++; )
        if( *p++ == '\0' || --i == 0 )
            return(1);
    return(0);
}

/* symsame - symbol member same as declared */
symsame(sp,hold,exact)  /* [vlh] */
struct symbol *sp, *hold;
short *exact;
{
    int index;

    index = (!indecl) ? stk_struct : in_struct;
#ifdef DEBUG
    if (symdebug) {
        printf("symsame (%d) %d: \n",index,indecl);
        printf("    chld [%s]\n",(sp->s_child)?sp->s_child->s_symbol:"NULL");
        printf("    sib  [%s]\n",(sp->s_sib)?sp->s_sib->s_symbol:"NULL");
        if (struc_parent[index])
            printf("    str par [%s] ",struc_parent[index]->s_symbol);
        else
            printf("    no str par ");
        if (sp->s_par>0)
            printf("sp par [%s] -- ",sp->s_par->s_symbol);
        else
            printf("no sp par %ld-- ",sp->s_par);
    }
#endif
    if (struc_parent[index]==sp->s_par) { /* all structures have parents */
#ifdef DEBUG
        if (symdebug)
            printf("exact\n");
#endif
        return(1);
    }
#ifdef DEBUG
    if (symdebug)
        printf("inexact\n");
#endif
    if (hold)
        if (sp->s_type != hold->s_type || sp->s_offset != hold->s_offset)
            *exact = 1;
    return(0);
}

/* symcopy - symbol copy*/
/*      Copies one symbol to another.*/
symcopy(p,q)                    /* returns - none*/
register char *p;               /* pointer to symbol to copy*/
register char *q;               /* pointer to area to copy to*/
{
    register short i;
#ifndef LNG_NMS
    for (i = SSIZE; --i != -1; )
        *q++ = ( *p ? *p++ : '\0');
#else
    while (*q++ = *p++)
        ;
#endif
}
