/**
 *  Copyright 1983, 1984
 *  Alcyon Corporation
 *  8716 Production Ave.
 *  San Diego, Ca.  92121
 *
 *  @(#)parser.h	2.12	1/29/85
**/

/**
 *  C68 Parser - include file
**/

#define PARSER 1

#ifdef vax11c
#   define VMS
#   define DECC
#endif

#ifdef PDP11
#   define SYM_TO_DSK
#   define NOSYS3
#   define NOWARN
#   define NO32INT
#endif

#ifdef WHITE
#   include <stdio.h>
#   include <klib.h>

#   undef putchar
#   define putchar xputchar
#   undef ferror
#   define ferror xferror
#   define printf xprintf
#endif

#ifdef VMS
#   define VAX11
#   ifdef DECC
#       include "ICODE"
#       define printf vprintf
#       define unlink delete
#   else
#       include "icode.h"
#   endif
#else
#   ifdef CPM
#       include "icode.h"
#   else
#       include "../icode.h"
#   endif
#endif

    /*symbol attribute fields*/
#define SRESWORD    001         /*is symbol a reserved word?*/
#define SGLOBAL     002         /*is symbol global?*/
#define STYPEDEF    004         /*typedef declaration?*/
#define SDEFINED    010         /*symbol defined?*/

    /*reserved words*/
#define R_AUTO      1
#define R_BREAK     2
#define R_CASE      3
#define R_CHAR      4
#define R_CONTINUE  5
#define R_DO        6
#define R_DEFAULT   7
#define R_DOUBLE    8
#define R_GOTO      9
#define R_ELSE      10
#define R_EXTERNAL  11
#define R_FLOAT     12
#define R_FOR       13
#define R_IF        14
#define R_INT       15
#define R_LONG      16
#define R_REGISTER  17
#define R_RETURN    18
#define R_SHORT     19
#define R_SIZEOF    20
#define R_STATIC    21
#define R_STRUCT    22
#define R_SWITCH    23
#define R_TYPEDEF   24
#define R_UNION     25
#define R_UNSIGNED  26
#define R_WHILE     27
#define R_ASM       28
#define R_ENUM      29
#define R_VOID      30

    /*
     * mixed-mode conversions, entries in 2-d array indexed by:
     * (int,unsn,long,doub,ptr)
     * UI - unsigned int, UL - unsigned long, SI - signed int,
     * SL - signed long, CH - char, DB - double, FL - float,
     * PT - pointer
     */
#define BADCV   23
#define NO_CV   0
#define SI_CH   1
#define UI_CH   SI_CH
#define SL_CH   SI_CH
#define UL_CH   SI_CH   /*[vlh] 4.4*/
#define DB_CH   SI_CH
#define PT_CH   SI_CH
#define SI_UI   NO_CV   /*no conversion is generated*/
#define SI_SL   2
#define SI_UL   3       /*[vlh] 4.4*/
#define SI_FL   4
#define SI_DB   SI_FL   /*[vlh] 4.7*/
#define SI_PT   5
#define UI_SI   NO_CV   /*no conversion is generated*/
#define UI_SL   6
#define UI_UL   SI_UL   /*[vlh] 4.4*/
#define UI_FL   7
#define UI_DB   UI_FL   /*[vlh] 4.7*/
#define UI_PT   8
#define SL_SI   9
#define UL_SI   SL_SI   /*[vlh] 4.4*/
#define SL_UI   10
#define UL_UI   SL_UI   /*[vlh] 4.4*/
#define SL_UL   NO_CV   /*[vlh] 4.4*/
#define UL_SL   NO_CV   /*[vlh] 4.4*/
#define SL_FL   11
#define UL_FL   SL_FL
#define SL_DB   SL_FL   /*[vlh] 4.7*/
#define UL_DB   SL_DB   /*[vlh] 4.4*/
#define SL_PT   12
#define UL_PT   SL_PT   /*[vlh] 4.4*/
#define DB_SI   13
#define DB_UI   FL_UI   /*[vlh] 4.7*/
#define FL_UI   14
#define FL_SI   FL_UI
#define FL_SL   15
#define FL_UL   FL_SL   /*[vlh] 4.7*/
#define DB_SL   16      /*[vlh] 4.7*/
#define DB_UL   FL_SL   /*[vlh] 4.7*/
#define PT_SI   17
#define PT_UI   PT_SI
#define PT_SL   18
#define PT_UL   PT_SL   /*[vlh] 4.4*/
#define PT_PT   19
#define FL_DB   20      /*[vlh] 4.7*/
#define DB_FL   21      /*[vlh] 4.7*/

	/* Bit Field Constants */
#define BITSPCHAR   8           /*bits per char*/
#define BITSPWORD   16          /*bits per word*/
#define BITSPLONG   32          /*bits per long-word*/
#define CHRSPWORD   2           /*chars per word*/
#define CHRSPLONG   4           /*chars per long-word*/

    /* miscellaneous constants */
#define OPSSIZE     40          /*operator stack size*/
#define OPDSIZE     80          /*operand stack size*/
#define HSIZE       512         /*hash table size, 3.4 made prime */
#define BSIZE       512         /*io buffer size */
#define SWSIZE      256         /*max no. of cases in a switch*/
#define DSIZE       1000        /*dimension table size*/
#define AREGLO      010         /*A reg flag*/
#define DREG        0100        /*data loadable into D-register?*/
#define HICREG      2           /*highest reg # used for code gen*/
#define STRSIZE     300         /*max string length*/
#define NFARGS      40          /*max no. of args to function*/
#define NFRSTR      128         /*max no. of forward ref struct proto*/
#define PATHSIZE    128
#define SCOPE_LEVLS 50          /* [vlh] 4.2, # of scope levels */
#define GLOB_SCOPE  0           /* [vlh] 4.2, global level is 0 */
#define FUNC_SCOPE  1           /* [vlh] 4.2, function level is 1 */
#define STDERR      2           /* [vlh] 4.2, error ==> STDERR... */
#ifndef PDP11
#   define SYME_NUM    40       /*number of symbol structures to allocate*/
#else
#   define SYME_NUM    5        /*number of symbol structures to allocate*/
#endif
#define SYM_SIZE        128     /*symbol strings size*/

    /*symbol table node*/
struct symbol {
    char s_attrib;          /* defined, resword, global, typedef */
    char s_sc;              /* auto, static, external, register */
    short s_type;           /* 4bits specified, 2 bit fields for ptr */
    short s_dp;             /* index into dimension table */
    short s_ssp;            /* dimension table/function arg table */
    short s_offset;         /* offset inside of structure */
    short s_scope;          /* [vlh] 4.2 scope of symbol */
#ifndef LNG_NMS
    char s_symbol[SSIZE];   /* symbol identifier, to SSIZE chars */
#else
    char *s_symbol;         /* symbol identifier, unlimited size */
#endif
#ifndef SYM_TO_DSK
    struct symbol *s_par;   /* if struct, ptr to parent (sys III) */
/* If sc == STELCL and type == PTR|STRUCT, this will point to PTR|STR entry */
    struct symbol *s_child; /* if struct, ptr to 1st child (sys III) */
    struct symbol *s_sib;   /* if struct, ptr to sibling (sys III) */
    struct symbol *s_next;  /* next symbol table entry */
#else
    long s_par;             /* if struct, ptr to parent (sys III) */
    long s_child;           /* if struct, ptr to 1st child (sys III) */
    long s_sib;             /* if struct, ptr to sibling (sys III) */
    long s_next;            /* next symbol table entry */
#endif
};

    /*expressioon tree node for external symbol - need to keep name*/
struct extnode {
    short t_op;
    short t_type;
    short t_dp;
    short t_ssp;
    short t_sc;
    short t_offset;
#ifndef LNG_NMS
    char t_symbol[SSIZE];           /*symbol name array*/
#else
    char *t_symbol;                 /*symbol name pointer*/
#endif
    short t_reg;
};

    /*expression tree operator node*/
struct tnode {
    short t_op;
    short t_type;
    short t_dp;
    short t_ssp;
    struct tnode *t_left;
    struct tnode *t_right;
};

    /*expression tree node for symbol - only keeps location*/
struct symnode {
    short t_op;
    short t_type;                 /*data type of symbol*/
    short t_dp;                   /*dimension pointer of symbol*/
    short t_ssp;                  /*structure size index to dtab*/
    short t_sc;                   /*storage class of symbol*/
    short t_offset;               /*offset of symbol*/
    short t_label;
};

    /*expression tree node for integer constant*/
struct conode {
    short t_op;
    short t_type;
    short t_dp;
    short t_ssp;
    short t_value;                /*constant value*/
};

    /* long constant node structure */
struct lconode {
    short t_op;
    short t_type;
    short t_dp;
    short t_ssp;
    long t_lvalue;              /*constant value*/
};

    /* [vlh] 4.7, floating point constant node structure */
struct fpconode {
    short t_op;
    short t_type;
    short t_dp;
    short t_ssp;
    long  t_fpvalue;              /*constant value*/
    long  t_fp2value;             /*2nd 32 bit constant value*/
};

    /* key word table */
struct resword {
    char *r_name;
    int r_value;
};
extern struct resword reswords[];

    /* switch table structure */
struct swtch {
    short sw_label;
#ifndef NO32INT
    long sw_value;
#else
    short sw_value;
#endif
} swtab[SWSIZE];

    /*operator and operand stack used by expr*/
struct ops {                    /*operator stack*/
    short o_op;                 /*operator*/
    short o_pri;                /*priority*/
} opstack[OPSSIZE], *opp;
    
    /*output buffers for intermediate code and strings*/
struct iob {
    int fd;
    int cc;
    char *cp;
    char cbuf[BSIZE];
} obuf, lbuf, sbuf, ibuf, *obp;

    /* Symbols Used by the on disk symbol table handler */
#ifdef SYM_TO_DSK
    long dsk_offset;            /* location for next symbol entry */
    struct symbol volatile;     /* very temporary structure */
    struct symbol csp_entry;    /* symbol storage space */
    struct symbol dsp_entry;    /* symbol storage space */
    struct symbol tdp_entry;    /* symbol storage space */
    long csp_addr, dsp_addr;    /* location....... */
    long tdp_addr;
    int dsk_fd;
    char dskfile[];
#endif

    /* Miscellaneous Variables for declarations */
short scope_decls[SCOPE_LEVLS]; /*[vlh] 4.2 decls at this scope ?? */
short scope_level;              /*[vlh] 4.2, global=0, func=1 */
short indecl;                   /*[vlh] 4.2, are we in a decl ?? */
short predecl;                  /*[vlh] 4.2, value previous to sizeof */    
short tdflag;                   /*declaration is a typedef proto*/
struct symbol *tdp;             /*points to typedef prototype*/
short naregs;                   /*keeps track of ptr registers alloc'd*/
short ndregs;                   /*keep track of data registers alloc'd*/
short boffset;                  /*current bit offset in structure*/
short in_struct;                /*set when in structure declaration*/
short stk_struct;               /*expression structure parent nest level*/
short eff_parent[10];           /*Parent in effect at this level ?*/

    /* Miscellaneous Variables for expression handling */
short opdotsave;                /* vars used by the expression evaluator */
short opdontop;                 /*op on top of expr stack ?? */
char *opdsave, *oprsave;
char *opdstack[OPDSIZE];        /*operand stack*/
char **opdp;                    /*operand stack pointer*/
char *opap;                     /*ptr to next avail loc in exprarea*/
extern short opinfo[];          /*operator info table*/
short commastop;                /*stop parse at comma*/
short colonstop;                /*stop parse at colon*/
extern int paren_level;         /*[vlh] 4.7, how many left parens */
extern int in_func;             /*[vlh] 4.7, level of parens before arg search*/

    /* Miscellaneous Variables for statement generation */
short cswp;                     /*current low switch table index*/
short clabel;                   /*continue label*/
short blabel;                   /*break label*/
short rlabel;                   /*return label*/
short dlabel;                   /*default label*/
    
    /* Miscellaneous Variables */
short lineno;                   /*current line number of input*/
short lst_ln_id;                /*[vlh] 4.2 last line an id was output on...*/
short cr_last;                  /* determine if # is file specification */
short errcnt;                   /*count of errors*/
char source[PATHSIZE];          /*[vlh]source filename for err rpting*/
struct tnode *frp;              /*pointer to function return info node*/
short smember;                  /*set when seen . or ->*/
short instmt;                   /*[vlh] 4.1 in a stmt*/
short infunc;                   /*set when in function body*/
short reducep;                  /*[vlh] if(procid); reduction*/
short peektok;                  /*peeked at token*/

    /* Parser Variables which are initialized in parser.ext */
extern char *exprp;             /*place to start building expression*/
extern short swp;               /*current entry in switch table*/
extern short nextlabel;         /*generates unique label numbers*/
extern short structlabel;       /*generates unique label names*/
extern char dinfo[];
extern char aregtab[];
extern char dregtab[];

    /* Parser flags */
extern short fflag;             /*[vlh] 3.4 software FFP floats */
extern short eflag;             /*[vlh] 3.4 software IEEE floats */
short hfpflag;                  /*[vlh] 4.7 hardware IEEE floats */
short gflag;                    /*[vlh] 4.2 symbolic debugger flag */
short tflag;                    /*[vlh] 4.1, put strings into text seg*/
short wflag;                    /*[vlh] don't generate warning mesgs*/
#ifndef NO32INT
    short longint;              /*[vlh] 4.7, 32 bit integers */
#endif
#ifdef VERSADOS
    short vdosrom;              /*[vlh] 4.7, xref and xdef matching....*/
#endif
#ifdef DEBUG
short debug;                    /*[vlh] 4.1, debug flag */
short initdebug;                /*[vlh] 4.2, init debug flag */
short symdebug;                 /*[vlh] 4.2, sym debug flag */
short treedebug;                /*[vlh] 4.2, expr tree debug flag */
#endif

    /*dimension table*/
long dtab[DSIZE];               /* [vlh] 3.4 short => long */
short cdp;                      /*next entry in dtab to alloc*/

    /*lexical analyzer values*/
short cvalue;                   /*current token if keyword or CINT*/
short ccbytes;                  /*number of bytes in char constant*/
short cstrsize;                 /*current string size*/
long clvalue;                   /*current token value if long constant*/
long cl2value;                  /*2nd 32 bits if floating point constant */
struct symbol *csp;             /*current token symbol ptr if SYMBOL*/
char cstr[STRSIZE];             /*current token value if CSTRING*/
struct symbol *dsp;             /*declarator symbol pointer*/

    /* 0 no structure */
#ifndef SYM_TO_DSK
    struct symbol *struc_parent[10];/*[vlh] ptrs to struc symbols*/
    struct symbol *struc_sib[10];   /*[vlh] ptrs to struc symbols*/
    struct symbol *hold_sib;        /*[vlh] wrap sib past struct decl*/
#else
    long struc_parent[10];          /*[vlh] address of struc symbols*/
    long struc_sib[10];             /*[vlh] address of struc symbols*/
    long hold_sib;                  /*[vlh] wrap sib past struct decl*/
#endif

    /*function argument table, used to collect function parameters*/
struct farg {
#ifndef SYM_TO_DSK
    struct symbol *f_sp;
#else
    long f_sp;
#endif
    short f_offset;
} fargtab[NFARGS];

    /*forward referenced structure prototype names*/
#ifndef SYM_TO_DSK
    struct symbol *frstab[NFRSTR];
#else
    long *frstab[NFRSTR];
#endif
short frstp;

    /* Macro's used by the Parser */
#define MAX(a,b)            ((a>=b) ? a : b)
#ifdef SYM_TO_DSK
/* setup address saving, structure assignment, set pointer to structure */
#   define ASSG(a,na,e,ne,p) a = na; e = ne; p = &e
#endif
#ifndef NOSYS3
#   define ISVOID(type)     ((type&TYPE)==VOID)
#   define ISCHAR(type)     (type==CHAR||type==UCHAR)
#   define ISBTCHAR(type)   ((type&TYPE)==CHAR||(type&TYPE)==UCHAR)
#   define ISBTSHORT(type)  ((type&TYPE)==SHORT||(type&TYPE)==USHORT)
#   define ISCARR(type)     (type==(CHAR|ARRAY)||type==(UCHAR|ARRAY))
#   define ISLONG(type)     (type==LONG||type==ULONG)
#   define UNSIGN(type)     (type==UCHAR||type==UNSIGNED||type==ULONG)
#   define NOTVFUNC(type)   (type!=(FUNCTION|VOID))
#   define NOTPVFUNC(type)  (type!=((FUNCTION<<2)|POINTER|VOID))
#   define ISCONST(op)      (op==CINT||op==CLONG)
#else
#   define ISCHAR(type)     (type==CHAR)
#   define ISBTCHAR(type)   ((type&TYPE)==CHAR)
#   define ISBTSHORT(type)  ((type&TYPE)==SHORT)
#   define ISCARR(type)     (type==(CHAR|ARRAY))
#   define ISLONG(type)     (type==LONG)
#   define UNSIGN(type)     (type==UNSIGNED)
#endif
#define ISSHORT(type)       (type==SHORT||type==USHORT)
#define ISARRAY(type)       ((type&SUPTYP)==ARRAY)
#define ISFUNCTION(type)    ((type&SUPTYP)==FUNCTION)
#define ISPOINTER(type)     ((type&SUPTYP)==POINTER)
#define ISSTRUCT(type)      ((type&TYPE)==STRUCT||(type&TYPE)==FRSTRUCT)
#define ISPSTRUCT(type)     (type==(STRUCT|POINTER)||type==(FRSTRUCT|POINTER))
#define NOTARRAY(type)      ((type&SUPTYP)!=ARRAY)
#define NOTFUNCTION(type)   ((type&SUPTYP)!=FUNCTION)
#define NOTPOINTER(type)    ((type&SUPTYP)!=POINTER)
#define ISTYPEDEF(sp)       (sp->s_attrib&STYPEDEF)
#define IN_NEST()           ((in_func != -1) && (paren_level > (in_func+1)))
#define WALIGN(add)         ((add+1)&(~1))
#ifndef NO32INT
#   define LWALIGN(add)     ((add+3)&(~3))  /* [vlh] 4.7, long word align */
    /* [vlh] 4.7, argument alignment dependent upon size of INT */
#   define AALIGN(add)      (!longint) ? WALIGN(add) : LWALIGN(add)
#   define INTTYPE          (!longint) ? INT : LONG
#   define UINTTYPE         (!longint) ? UNSIGNED : ULONG
#else
    /* [vlh] 4.7, argument alignment dependent upon size of INT */
#   define AALIGN(add)      WALIGN(add)
#   define INTTYPE          INT
#   define UINTTYPE         UNSIGNED
#endif
#define BTYPE(type)         (type&TYPE)
#define SUPTYPE(type)       (type&SUPTYP)
#define ISALLTYPE(type)     (type&(SUPTYP|TYPE))
#define ASGNOP(op)          ((opinfo[op]&OPASSIGN)!=0)
#define RELOP(op)           ((opinfo[op]&OPREL)!=0)
#define COMOP(op)           ((opinfo[op]&OPCOM)!=0)
#define LINTEGRAL(op)       ((opinfo[op]&OPLWORD)!=0)
#define RINTEGRAL(op)       ((opinfo[op]&OPRWORD)!=0)
#define RASOP(op)           ((opinfo[op]&OPRAS)!=0)
#define BINOP(op)           ((opinfo[op]&OPBIN)!=0)
#define UNARYOP(op)         ((opinfo[op]&OPBIN)==0)
#define LEAF(op)            ((opinfo[op]&OPTERM)!=0)
#define LVALOP(op)          ((opinfo[op]&OPLVAL)!=0)
#define OPPRIORITY(op)      (opinfo[op]&OPPRI)
#define SIMPLE_TYP(typ)     ((typ>=CHAR) && (typ<=DOUBLE))

    /* checks for symbol with structure element storage class */
#define ISSTEL(tp)  (tp->t_op==SYMBOL && (SESC(tp)))
#define SESC(x)     (x->t_sc==STELCL||x->t_sc==UNELCL||x->t_sc==BFIELDCL)

    /* peek at next token, if not read token put back, else delete */
    /* 1 if matched, 0 otherwise */
#define PEEK(tok)   ( (peektok=gettok(0)) == tok )

    /* outbentry - output symbol '%' */
	/*   signifying routine entry, for link info */
#define OUTBENTRY() printf("%%\n")
#define OUTGOTO(lab)        if( lab > 0 ) printf("(bra L%d\n",lab)
    /* change to text segment */
#define OUTTEXT()       printf("(.text\n")
    /* change segment to bss */
#define OUTBSS()        printf("(.bss\n")
    /* get on a word boundary */
#define OUTEVEN()       printf("(.even\n")
#ifndef LNG_NMS
        /* output common symbol references */
#   define OUTCOMMON(sym,size) printf("(.comm _%.8s,%ld\n",sym,size)
        /* output global symbol references */
#   define OUTEXTDEF(sym)  printf("(.globl _%.8s\n",sym)
        /* output function label */
#   define OUTFLAB(sym)    printf("(_%.8s:\n(~~%.8s:\n",sym,sym)
        /* output data label */
#   define OUTDLAB(sym)    printf("(_%.8s:\n",sym)
#else
        /* output common symbol references */
#   define OUTCOMMON(sym,size) printf("(.comm _%s,%ld\n",sym,size)
        /* output global symbol references */
#   define OUTEXTDEF(sym)  printf("(.globl _%s\n",sym)
        /* output function label */
#   define OUTFLAB(sym)    printf("(_%s:\n(~~%s:\n",sym,sym)
        /* output data label */
#   define OUTDLAB(sym)    printf("(_%s:\n",sym)
#endif
    /* outputs reserved memory [vlh] 3.4 %d => %ld */
#define OUTRESMEM(size) printf("(.ds.b %ld\n",size)
    /* output padding for word alignments */
#define OUTPAD()        printf("(.even\n")
    /* output long constant to assembler */
#define OUTLCON(val)    printf("(.dc.l $%lx\n",val)
    /* output label constant */
#define OUTCLAB(lab)    printf("(.dc.l L%d\n",lab)
    /* output a label */
#define OUTLAB(lab)     printf("(L%d:\n",lab)
    /* output a null tree */
#define OUTNULL()       printf("0\n")

    /* Debugging Macros */
#ifdef DEBUG
#   define PUTEXPR(dbg,id_str,node_ptr) if (dbg) putexpr(id_str,node_ptr)
#else
#   define PUTEXPR(dbg,id_str,node_ptr) 
#endif

    /* On Disk Symbol Table macro */
#ifdef SYM_TO_DSK
#   define TO_DSK(symp,addr)    write_st(symp,addr)
#   define READ_ST(symp,addr)   read_st(symp,addr)
#   define ZERO_DSP()           dsp_addr = dsp = 0;
#else
#   define TO_DSK(symp,addr)
#   define READ_ST(symp,addr)
#   define ZERO_DSP()           dsp = 0
#endif

    /*functions returning pointers*/
char *expr();
char *talloc();
char *tnalloc();
char *enalloc();
char *snalloc();
char *cnalloc();
char *lcnalloc();
#ifndef NOFP
char *fpcnalloc();
#endif
char *popopd();
char *cvopgen();
char *arrayref();
char *funcref();
char *install();
char *lookup();
char *balpar();
char *get_symbol();     /* [vlh] 4.2 split from expr() */
#ifndef LNG_NMS
char *sbrk();
#else
char *malloc();
#endif
char *mktemp();

long initlist();
long dsize();
long psize();
long dodecl();
long dlist();
long getdec();
long gethex();
long getoct();
long cexpr();
long s_or_a();
long str_init();
long outstr();
long dosizeof();
