/*
    Copyright 1982
    Alcyon Corporation
    8716 Production Ave.
    San Diego, Ca.  92121

    @(#)interf.c	2.4 11/15/84
*/

#include "parser.h"

outinit(tp,type)                        /* returns - none*/
struct tnode *tp;
int type;
{
#ifndef NOWARN
    if (tp->t_type == TYPELESS)
        warning("undeclared initializer: %s",tp->t_symbol);
#endif
    outexpr(tnalloc(INIT,type,0,0,tp));
}

outcforreg(tp)
struct tnode *tp;
{
    outexpr(tnalloc(CFORREG,tp->t_type,0,0,tp));
}

outifgoto(tp,dir,lab)
struct tnode *tp;
int dir;
int lab;
{
    outexpr(tnalloc(IFGOTO,dir,lab,0,tp));
}

/* outasm - outputs asm literal.         [vlh] 4.2 asm instruction */
outasm()
{
    register char *p;

    if (lineno != lst_ln_id) {
        outline();
        OUTNULL();
    }
    putchar('(');
    for (p = cstr; *p ; p++) {
        putchar(*p);
        if (*p == '\n')
            putchar('(');
    }
    putchar('\n');
}

outexpr(tp)
struct tnode *tp;
{
    if (!tp)
        return;
    outline();
    outtree(tp);
}

/* interprets and prints the parse tree */
outtree(tp)
struct tnode *tp;
{
    short w1, w2;

    if( !tp )
        return;
    
    printf("%x.%x",tp->t_op,tp->t_type);
    if(tp->t_type==STRUCT)  /* [vlh] 4.5, output structure size to cgen */
        printf(".%lx",(tp->t_ssp) ? dosizeof(tp,0) : 0L);
    else if (tp->t_type==(STRUCT|POINTER))
        printf(".%lx",(dtab[tp->t_ssp]) ? psize(tp) : 0L);

    switch( tp->t_op ) {

        case CINT:
            printf(".%x\n",((struct conode *)tp)->t_value);
            break;

        case CLONG:
            w1 = ((struct lconode *)tp)->t_lvalue.hiword; 
            w2 = ((struct lconode *)tp)->t_lvalue.loword;
            printf(".%x.%x\n",w1,w2);
            break;

#ifndef NOFP
        case CDOUBLE:   /*[vlh] 3.4*/
            w1 = ((struct lconode *)tp)->t_fpvalue.hiword; 
            w2 = ((struct lconode *)tp)->t_fpvalue.loword;
            if (hfpflag) {  /* [vlh] 4.7 - Double.... */
                printf(".%x.%x",w1,w2);
                w1 = ((struct lconode *)tp)->t_fp2value.hiword; 
                w2 = ((struct lconode *)tp)->t_fp2value.loword;
            }
            printf(".%x.%x\n",w1,w2);
            break;
#endif

        case SYMBOL:
            printf(".%x",((struct symnode *)tp)->t_sc);
            if( ((struct symnode *)tp)->t_sc == EXTERNAL )
#ifndef LNG_NMS
                printf(".%.8s\n",tp->t_symbol);
#else
                printf(".%s\n",tp->t_symbol);
#endif
            else
                printf(".%x\n",tp->t_offset);
            break;

        case 0:
            putchar('\n');
            break;

        case IFGOTO:
        case BFIELD:
            printf(".%x\n",tp->t_dp);
            outtree(tp->t_left);
            break;

        default:
            putchar('\n');
            outtree(tp->t_left);
            if( BINOP(tp->t_op) ) {
                outtree(tp->t_right);
            }
            break;
    }   /* end of case... */
}

