/*
    Copyright 1982, 1983
    Alcyon Corporation
    8716 Production Ave.
    San Diego, Ca.  92121

    @(#)icode.c	2.8 1/7/85
*/

/**
 *  This interfaces the Parser and the Code Generator, note that these
 *  allow you to link together the Parser and the Code Generator.
**/

#include "parser.h"
#ifdef VERSADOS
#   define v6fflush fflush
    int inerr;
#endif

#define LMIN(x,y) (x <= y) ? x : y
#define LMAX(x,y) (x >= y) ? x : y

#define SAVESTATE(sp,xbuf,sb) sp=obp; obp= &xbuf; sb=bol; bol=1
#define RESTORSTATE(savep,sb) obp=savep; bol=sb

short inittype;
short begseq;
short begseq;
short bol = 1;

/* output current line number into icode */
outline() 
{
    printf(".%x.%s\n",lineno,source);
    lst_ln_id = lineno;
}

/* defbdata - set up for byte data, was outbdata */
defbdata()                                  /* returns - none*/
{
    inittype = CHAR;
    printf("(.dc.b ");
}

/* defwdata - set up for word data, was outwdata */
defwdata()                                  /* returns - none*/
{
    inittype = INT;
    printf("(.dc.w ");
}

/* defldata - set up for long data, [vlh] 4.2 */
defldata()
{
    inittype = LONG;
    printf("(.dc.l ");
}

/* outc - output a constant*/
outc(type,value)                            /* returns - none*/
int type;
int value;
{
    if( type == CHAR )
        defbdata();
    else
        defwdata();
    printf("$%x\n",value);  /* [vlh] 4.2, changed to hex... */
}

/* outdata - set up for data output*/
outdata()                               /* returns - none*/
{
    inittype = INT;
    printf("(.data\n");
}

/* outldata - set up for long data output*/
outldata()                              /* returns - none*/
{
    inittype = LONG;
    printf("(.data\n");
}

#ifndef NOFP
/* outfpdata - set up for floating point data output*/
outfpdata()                             /*[vlh] 3.4 returns - none*/
{
    inittype = FLOAT;
    printf("(.data\n");
}

/* outfpdata - set up for floating point data output*/
outdfpdata()                             /*[vlh] 4.7 returns - none*/
{
    inittype = DOUBLE;
    printf("(.data\n");
}
#endif

/* outbexit - output function exit code*/
outbexit(nlocs,nds,nas)                 /* returns - none*/
int nlocs;                              /* [vlh] 4.2 */ 
int nds;                                /* number of D registers*/
int nas;                                /* number of A registers*/
{
    struct iob *savep;
	short sbol;

    if (gflag)  /* [vlh] 4.2 for symbolic debugger */
        printf("(~_lE%d:\n",lineno);
    if( nds || nas ) {
        printf("(tst.l (sp)+\n(movem.l (sp)+,");  /*1 arg stuff*/
        if( nds ) {
            printf("R%d-R7",8-nds);
            if( nas )
                putchar('/');
        }
        if( nas )
            printf("R%d-R13",14-nas);
        putchar('\n');
    }
    printf("(unlk R14\n(rts\n");
    SAVESTATE(savep,lbuf,sbol);
    if( !nds && !nas )      /* adjust for 1 arg*/
        nlocs += 4;
    printf("link R14,#%d\n",-nlocs);    /* literal asm in link file */
    if (nds || nas) {
        printf("movem.l R%d-R7",7-nds);
        if (nas)
            printf("/R%d-R13,-(sp)\n",14-nas);
        else 
            printf(",-(sp)\n");
    }
#ifdef REGULUS
#   ifdef MC68000
    printf("tst.b -100(sp)\n"); /* 4.8, for Mike, stack checking */
#   endif
#endif
    putchar('%');
    RESTORSTATE(savep,sbol);
}

/* outlocal - output local symbol for debugger*/
outlocal(isparam,type,sc,sym,val,off)
int isparam;
int type;                               /* local name type*/
int sc;                                 /* storage type*/
char *sym;                              /* symbol name*/
int val;
int off;
{
    switch( sc ) {

        case STATIC:
            if( NOTFUNCTION(type) )
#ifndef LNG_NMS
                printf("(~%.8s=L%d\n",sym,val);
#else
                printf("(~%s=L%d\n",sym,val);
#endif
            break;

        case REGISTER:
        case PDECREG:
#ifndef LNG_NMS
            printf("(~%.8s=R%d\n",sym,val);
            if (isparam)
                printf("(~%.8s=%d\n",sym,off);
#else
            printf("(~%s=R%d\n",sym,val);
            if (isparam)
                printf("(~%s=%d\n",sym,off);
#endif
            break;

        case AUTO:
        case PDECLIST:
#ifndef LNG_NMS
            printf("(~%.8s=%d\n",sym,val);
#else
            printf("(~%s=%d\n",sym,val);
#endif
            break;
    }
}

#define DSW "(cmp.l (R8)+,R0\n(dbeq R1,L%d\n(move.l %d(R8),R8\n(jmp (R8)\n"

/* outswitch - output switch table info*/
outswitch(ncases,deflab,sp)     /* returns - none*/
int ncases;                     /* number of cases in switch*/
int deflab;                     /* default label*/
struct swtch *sp;               /* switch table pointer*/
{
    register short i, tlab;
    register struct swtch *s;
    long val, lswvalue, hval, vdif;

    val = sp->sw_value;
    hval = sp[ncases-1].sw_value;
    vdif = hval - val;
    if (ncases <= 4) {
    /**
     * simple switch, do compares and branches, followed by branch to default
    **/
        for( s = sp; --ncases >= 0; s++ ) {
            if (!s->sw_value)
#ifndef NO32INT
                printf("(tst%sR0\n",(longint)?".l ":" ");
#else
                printf("(tst R0\n");
#endif
            else
#ifndef NO32INT
                if (longint)
                    printf("(cmp.l #%ld,R0\n",s->sw_value);
                else
                    printf("(cmp #%ld,R0\n",s->sw_value);
#else
                printf("(cmp #%d,R0\n",s->sw_value);
#endif
            printf("(beq L%d\n",s->sw_label);
        }
        OUTGOTO(deflab);
    }
    else if( vdif > 0 && vdif <= ncases*3 ) {

    /*jump switch, uses value in R0 to index into table of labels*/

        if (val)
#ifndef NO32INT
            if (longint)
                printf("(sub.l #%ld,R0\n",val);
            else
#endif
                printf("(sub #%ld,R0\n",val);
        tlab = nextlabel++;
#ifndef NO32INT
        if (!longint) {
#endif
            printf("(cmp #%ld,R0\n(bhi L%d\n",vdif,deflab);   /*check for max*/
            printf("(asl #2,R0\n(move R0,R8\n(add.l #L%d,R8\n",tlab);
#ifndef NO32INT
        }
        else {
            printf("(cmp.l #%ld,R0\n(bhi L%d\n",vdif,deflab); /*check for max*/
            printf("(asl.l #2,R0\n(move.l R0,R8\n(add.l #L%d,R8\n",tlab);
        }
#endif
        printf("(move.l (R8),R8\n(jmp (R8)\n");
		if (!tflag)     /* [vlh] 4.9 */
			outdata();
		else            /* [vlh] 4.9, output case table  into text segment */
			OUTTEXT();
        OUTLAB(tlab);
        for( s = sp; val <= hval; val++ ) {
            if (val == s->sw_value) {
                OUTCLAB(s->sw_label);
                s++;
            }
            else
                OUTCLAB(deflab);
        }
        OUTTEXT();
    }
    else {
    /**
     * direct switch, searches down table of values for match, if match
     * found, branches to corresponding label in label table.
    **/
        tlab = nextlabel++;
        printf("(ext.l R0\n(move.l #L%d,R8\n(move #%d,R1\n",tlab,ncases);
        i = nextlabel++;
        OUTLAB(i);                  /*loop label*/
        printf(DSW,i,ncases*4);
		if (!tflag)     /* [vlh] 4.9 */
			outdata();
		else            /* [vlh] 4.9, output case table  into text segment */
			OUTTEXT();
        OUTLAB(tlab);
        for( s = sp, i = ncases; --i >= 0; s++ ) {
            lswvalue = s->sw_value;
            OUTLCON(lswvalue);
        }
        OUTLCON(0L);                        /* mark for default label*/
        for( s = sp, i = ncases; --i >= 0; s++ )
            OUTCLAB(s->sw_label);
        OUTCLAB(deflab);
        OUTTEXT();
    }
}

outeof()
{
    v6fflush(&lbuf);
    v6fflush(&sbuf);
    v6fflush(&obuf);
}

/* copysfile - copy string file to end of output file*/
copysfile(fname)
char *fname;
{
    register short c;

    close(sbuf.fd);
    if( fopen(fname,&sbuf,0) < 0 )      /* 3rd arg for versados */
        ferror("can't copy %s",fname);
    while( (c=getc(&sbuf)) > 0 )
        putc(c,&obuf);
    v6fflush(&obuf);
}

/* outword - output a word of data*/
outword(w)                              /* word expression*/
int w;
{
    if( begseq )
        putchar(',');
    begseq++;
    printf("$%x",w);    /* [vlh] 4.2, changed to hex... */
}

/* outlong - output a long data, [vlh] 4.2 changed for dc.l */
/* outfp - output floating point data, [vlh] 4.2 changed for dc.l */
outfp_or_l(l)                   /*[vlh] 3.4 returns - none*/
long l;                         /* long data (float or fixed point) to output*/
{
    defldata();
    printf("$%lx",l);
    outendseq();
}

outendseq()                             /* returns - none*/
{
    begseq = 0;
    putchar('\n');
}

/**
 * outtstr - output text string
 *      This outputs a string to the string file, this is used wherever
 *      you cannot output the string directly to data space, such as in
 *      the middle of expressions.
**/
outtstr(lab)
int lab;
{
    struct iob *savep;
	short sbol;

    SAVESTATE(savep,sbuf,sbol); /*save to restore later...*/
    printf("(L%d:\n",lab);
    outstr((long)cstrsize,(long)cstrsize);
    RESTORSTATE(savep,sbol);
}

/* outstr - output a string as a sequence of bytes*/
/*      Outputs ".dc.b <byte1>,<byte2>,...,<0>*/
long
outstr(maxsize,strsize)
long maxsize, strsize;
{
    register char *s;
    register long i;

    defbdata();
    i = LMIN(strsize,maxsize);
    for( s = cstr; i > 0; i-- ) {
        outword((int)(*s++ & 0xff));
        if (begseq==30 && i > 2) {  /* [vlh] 4.1 */
            outendseq();    /* limit line length to something */
            defbdata();     /* reasonable, next .dc.b */
        }
    }
    outendseq();
    if (maxsize > strsize)
        OUTRESMEM((long)(maxsize - strsize));
#ifndef NOWARN
    else if (maxsize && (strsize > maxsize))
        warning("string initializer truncated",0);
#endif
    return(LMAX(strsize,maxsize));

}

/**
 * putchar - This catches tabs to allow for the integration of the
 *      parser and code generator into one pass.  By merely throwing
 *      away the tabs here, the output will be OK for the assembler.
 *      VERSADOS - handle outputting to intermediate or error files
**/
putchar(c)
char c;
{
#ifdef VERSADOS
    if (inerr) {
        versaputchar(c);
        return;
    }
#endif
#ifdef DEBUG
    if (debug > 1)
        cputc(c,2);
#endif
    putc(c,obp);
}
