
/**
 *  Copyright 1983
 *  Alcyon Corporation
 *  8716 Production Ave.
 *  San Diego, CA  92121
 *
 *  @(#)def.h	2.5	12/27/84
**/

/* Parser External Definition File */

    /*key word table*/
struct resword reswords[] = {
    "asm",      R_ASM,          /* [vlh] 4.2 */
    "auto",     R_AUTO,
    "break",    R_BREAK,
    "case",     R_CASE,
    "char",     R_CHAR,
    "continue", R_CONTINUE,
    "default",  R_DEFAULT,
    "do",       R_DO,
    "double",   R_DOUBLE,
    "goto",     R_GOTO,
    "else",     R_ELSE,
    "extern",   R_EXTERNAL,
    "float",    R_FLOAT,
    "for",      R_FOR,
    "if",       R_IF,
    "int",      R_INT,
    "long",     R_LONG,
    "register", R_REGISTER,
    "return",   R_RETURN,
    "short",    R_SHORT,
    "sizeof",   R_SIZEOF,
    "static",   R_STATIC,
    "struct",   R_STRUCT,
    "switch",   R_SWITCH,
    "typedef",  R_TYPEDEF,
    "union",    R_UNION,
    "unsigned", R_UNSIGNED,
    "while",    R_WHILE,
#ifndef NOSYS3
    "enum",     R_ENUM,
    "void",     R_VOID,
#endif
    0,
};

char dinfo[] = {
    0,                              /*TYPELESS=0*/
    1|DREG,                         /*CHAR=1*/
    0,                              /*ENUM=2*/
    2|DREG,                         /*INT/SHORT=3*/
    4|DREG,                         /*LONG=4*/
    1|DREG,                         /*UCHAR=5*/
    2,                              /*VOID=6*/
    2|DREG,                         /*USHORT/UNSIGNED=7*/
    4|DREG,                         /*ULONG=8*/
    4|DREG,                         /*FLOAT=9[vlh]*/
    8|DREG,                         /*DOUBLE=10[vlh]*/
    0,                              /*STRUCT=11*/
    0,                              /*FRSTRUCT=12*/
    0,                              /*LLABEL=13*/
    0,                              /*INVALID=14*/
    0,                              /*INVALID=15*/
};

char aregtab[] = { AREG5, AREG4, AREG3, 0 };
char dregtab[] = { DREG7, DREG6, DREG5, DREG4, DREG3, 0 };

short nextlabel = 1;
short structlabel = 1;
char *exprp     = &exprarea[0];
short swp = -1;
#ifdef VERSADOS
#   ifdef FFLAG
        short fflag = 1; 
        short eflag = 0;
#   else
        short fflag = 0; 
        short eflag = 1;
#   endif
#else
    short eflag = 1;
    short fflag = 0;
#endif


/**
 * This indicates if a conversion operator is needed given the types
 * of the two operands.  The upper diagonal is applied ONLY if this
 * is an assignment operator and the indexes are swapped so the lower
 * diagonal is used otherwise.
 *   SI     UI      SL      UL      PT      FL      DB
**/
char cvmap[7][7] = {
    NO_CV,  UI_SI,  SL_SI,  UL_SI,  PT_SI,  FL_SI,  DB_SI,  /* SI */
    SI_UI,  NO_CV,  SL_UI,  UL_UI,  PT_UI,  FL_UI,  DB_UI,  /* UI */
    SI_SL,  UI_SL,  NO_CV,  UL_SL,  PT_SL,  FL_SL,  DB_SL,  /* SL */
    SI_UL,  UI_UL,  SL_UL,  NO_CV,  PT_UL,  FL_UL,  DB_UL,  /* UL */
    SI_PT,  UI_PT,  SL_PT,  UL_PT,  PT_PT,  BADCV,  BADCV,  /* PT */
    SI_FL,  UI_FL,  SL_FL,  UL_FL,  BADCV,  NO_CV,  DB_FL,  /* FL */
    SI_DB,  UI_DB,  SL_DB,  UL_DB,  BADCV,  FL_DB,  NO_CV,  /* DB */
};
