/*
	Copyright 1983
	Alcyon Corp.
	8716 Production Ave.
	San Diego, Ca.  92121
*/

#include "loader.h"
#include "lx68.h"
#include <signal.h>
#include <errno.h>

char *version = "@(#)ranlib.c	2.6    1/25/85";

#define SYMDEF	"._SYMDEF"

#ifdef SELFBOOT
	char rfname[] = "/mnt/tmp/LRAXXXXX";
	char sefname[] = "/mnt/tmp/LSAXXXXX";
#	ifdef LNG_NMS
		char snfname[] = "/mnt/tmp/LNAXXXXX";
#	endif
#else
	char rfname[] = "/tmp/LRAXXXXX";
	char sefname[] = "/tmp/LSAXXXXX";
#	ifdef LNG_NMS
	char snfname[] = "/tmp/LNAXXXXX";
#	endif
#endif

char libname[MAXUFNAME];

struct nlist tsym;

char *symfile = "/tmp/RS_AXXXXX";
char *newlib = "RN_AXXXXX";
char *myname;
FILE *sfd;
long stsize;
short verbose;
short update;
extern int errno;

short zap();

main(argc,argv)
short argc;
char **argv;
{
	register struct libhdr *hd;
	register FILE *fp, *lfd;
	register long start, extra, offset;
	register short len;
	char *oldlib;
	unsigned short type;
	short new;
	struct libhdr lhdr;
	char buf[BUFSIZ];
	long modtime[2];

	myname = *argv++;
	argc--;
	new = 0;
	while( argc && **argv == '-' ) {
		switch( *++*argv ) {
		case 'u':
			update = 1;
			break;
		case 'v':
			verbose = 1;
			break;
		default:
usage:
			printf("usage: %s [-v] [-u] old [new]'\n",myname);
			exit(1);
		}
		argv++;
		argc--;
	}

	if( argc == 0 )
		goto usage;

	oldlib = *argv++;
	if( *argv ) {
		new = 1;
		newlib = *argv;
	}

	if( (lfd = fopen(oldlib,"r")) == NULL ) {
		printf("%s: can't open archive '%s'\n",myname,oldlib);
		exit(1);
	}

	lgetw(&type,lfd);
	if (type != LIBMAGIC && type != LIBRMAGIC) {
		printf("%s: invalid magic number %x in '%s'\n",myname,type,
					oldlib);
		exit(1);
	}

	if (update) {
		if (type != LIBRMAGIC) {
			printf("%s: can't update non-random library\n",myname);
			exit(1);
		}
		fclose(lfd);
		doupdate(oldlib);
	}

	signal(SIGINT,zap);
	mktemp(symfile);	/* make a symbol file */
	if( (sfd = fopen(symfile,"w+")) == NULL ) {
		printf("%s: can't create temp file\n",myname);
		exit(1);
	}

	start = offset = 2;
	extra = 0;
	hd = &lhdr;

	if (type == LIBRMAGIC) {
		getarhd(lfd,hd);
		if( strcmp(hd->lfname,SYMDEF) != 0 ) {
			printf("%s: symbol file not first member\n",myname);
			exit(1);
		}
		extra = hd->lfsize + LIBHDSIZE;
		start += extra;
		fseek(lfd,start,0);	/* skip the old symbol table */
	}

	while( getarhd(lfd,hd) != EOF ) {	/* process all the files */
		if( strcmp(hd->lfname,SYMDEF) == 0 )
			printf("%s: warning, symbol file skipped\n",myname);
		else if( *hd->lfname == 0 ) {
			printf("%s: warning, empty member\n",myname);
			continue;
		}
		else {
			if( verbose ) {
				hd->lmodti = 0;	/* close off the string */
				printf("%s\n",hd->lfname);
			}
			if( getsyms(offset,lfd) ) {
				printf("%s: %s not an object file\n",myname,hd->lfname);
				zap(1);
			}
		}
		offset += (hd->lfsize + LIBHDSIZE);
		fseek(lfd,offset+extra,0);
	}

	/* make the SYMDEF entry */
	strcpy(hd->lfname,SYMDEF);
	time(modtime);
	hd->lmodti = modtime[0];
	hd->luserid = 0;
	hd->lgid = 0;
	hd->lfimode = 0666;
	hd->lfsize = stsize * S_SYMSIZ;

	if( new == 0 )
		mktemp(newlib);	/* make a temporary library name in local dir */
	if( (fp = fopen(newlib,"w")) == NULL ) {
		printf("%s: can't create new library '%s'\n",myname,newlib);
		zap(1);
	}
	type = LIBRMAGIC;
	lputw(&type,fp);
	putarhd(fp,hd);	/* Write symbol table header */

	if( verbose )
		printf("copy symbols\n");
	fseek(sfd,0L,0);
	while (GETSYM(&tsym,sfd,NULL,NULL) != ERROR)	/* copy in the symbols */
		PUTSYM(&tsym,fp,NULL);
	fclose(sfd);
	unlink(symfile);

	if( verbose )
		printf("copy archive\n");
	fseek(lfd,start,0);
	while( (len = fread(buf,1,sizeof buf,lfd)) > 0 )	/* copy the library */
		fwrite(buf,1,len,fp);
	fclose(fp);
	fclose(lfd);

	if( new == 0 ) {
		unlink(oldlib);	/* remove old library */
		if( link(newlib,oldlib) == -1 ) {
			if( errno == EXDEV )
				cp(newlib,oldlib);
			else {
				printf("can't re-link, archive left in %s\n",newlib);
				exit(1);
			}
		}
		unlink(newlib);
		newlib = oldlib;
	}
	modtime[1] = modtime[0];
	utime(newlib,modtime);	/* force the library to match */
	exit(0);
}

getsyms(off,fp)
register long off;
register FILE *fp;
{
	register struct exec2 *ahd;
	register struct nlist *sym;
	register long l;
	struct exec2 aouthdr;

	ahd = &aouthdr;
	sym = &tsym;
	getchd(fp,ahd);
	if( ahd->a_magic != E_MAGIC )
		return(1);
	fseek(fp,(long)(ahd->a_text+ahd->a_data),1);	/* Seek to symbols */
	for( l = 0L; l < ahd->a_syms; l += S_SYMSIZ ) {
		GETSYM(sym,fp,NULL,NULL);
		if( (GLOBAL(sym->n_type) && (sym->n_type&(S_DATA|S_TEXT))) ||
				(COMMON(sym->n_type) && sym->n_value != 0) ) {
			sym->n_value = off;
			PUTSYM(sym,sfd,NULL);
			stsize++;
		}
	}
	return(0);
}

short
zap(n)
short n;
{
	unlink(newlib);
	unlink(symfile);
	exit(n);
}

cp(from,to)
char *from, *to;
{
	register int ifd, ofd, len;
	char buf[BUFSIZ];

	ifd = open(from,0);
	ofd = creat(to,0666);
	if( ifd == -1 || ofd == -1 ) {
		printf("%s: can't copy to '%s', archive left in '%s'\n",to,from);
		exit(1);
	}

	while( (len = read(ifd,buf,sizeof(buf))) > 0 )
		write(ofd,buf,len);
	close(ifd);
	close(ofd);
}

doupdate(name)
char *name;
{
	register struct libhdr *hd;
	register FILE *lfd;
	struct libhdr lhdr;
	long modtime[2];

	if( (lfd = fopen(name,"r+")) == NULL ) {
		printf("%s: sorry, can't write %s\n",myname,name);
		exit(1);
	}

	hd = &lhdr;

	fseek(lfd,2L,0);
	getarhd(lfd,hd);
	fseek(lfd,2L,0);

	if( strcmp(hd->lfname,SYMDEF) != 0 ) {
		printf("%s: symbol file not first member\n",myname);
		exit(1);
	}
	time(modtime);
	hd->lmodti = modtime[0];
	putarhd(lfd,hd);	/* Write symbol table header */
	fclose(lfd);
	modtime[1] = modtime[0];
	utime(name,modtime);	/* force the library to match */
	exit(0);
}
