/*
	Copyright 1983
	Alcyon Corp.
	8716 Production Ave.
	San Diego, Ca.  92121
*/

char *version = "@(#)LX68	2.5    1/15/85";

#include "loader.h"
#include "lx68.h"
#include <signal.h>

#ifndef MC68000
	/* VAX11 or PDP11 */
	char shrtexit[] = "/usr/local/lib/exit.o";
	char ofiledef[] = "c.out";
#else
#	include <sys/sysinfo.h>
	char shrtexit[] = "/lib/exit.o";
	char ofiledef[] = "a.out";
#endif

long bbase = 0;
long dbase = 0;
long tbase = 0;

main(argc,argv)
short argc;
char **argv;
{
	register char *fptr, **xargv;
	register char *xptr;
	register short i;
	int mmuflag;
	FILE *rfd, *sfd;

	if( signal(SIGINT,SIG_IGN) != SIG_IGN )
		signal(SIGINT,ldexit);	/* Set interrupt exit point */
	signal(SIGTERM,ldexit);
	if( argc < 2 ) {
		printf("usage: %s [[-Aname=name] [-Ealias] [-Ffile] [-BCDTUWXZimnors]] files [-l?]\n",*argv);
		ldexit(1);
	}
	symtinit();
	bflag = cflag = dflag = iflag = ignore = tflag = eflag = xflag = iflag =
		nflag = rflag = sflag = xitflg = aflag = errcnt = mflag = 0;

#ifdef MC68000
	sysinfo(I_MMUSTAT,&mmuflag);	/* Find out if mmu present */
	if( (mmuflag&M_STANFORD) != 0 || (mmuflag&M_MMU) == 0 )
		rflag = 1;
#endif

	argc--;
	for( xargv = argv, i = argc; --i != -1; ) {
		if( *(fptr = *++xargv) == '-' ) {
			switch( *++fptr ) {
				case 'A':
					aflag = 1;
					xptr = ++fptr;
					while( *fptr && *fptr != '=' )
						fptr++;
					if( *fptr )
						*fptr++ = 0;
					aliasym(xptr,fptr);
					continue;
				case 'B':
					bflag = 1;
					bbase = gethex(++fptr);
					continue;
				case 'C':
					cflag = 1;
					rflag = 1;
					xflag = 1;
					continue;
				case 'D':
					dflag = 1;
					dbase = gethex(++fptr);
					continue;
				case 'F':
					process(++fptr,RESOLVE);
					continue;
				case 'E':
					process(++fptr,ALIASES);
					aflag = 1;
					continue;
				case 'I':
					ignore = 1;
					continue;
				case 'T':
				case 'Z':
					tflag = 1;
					tbase = gethex(++fptr);
					continue;
				case 'U':
					makexref(++fptr);
					continue;
				case 'X':
					xflag = 1;
					continue;
				case 'i':
					iflag = 1;
					continue;
				case 'l':
					++fptr;
					if( readlib(fptr,0) )
						ldexit(1);
					continue;
				case 'n':
					if( *++fptr == '2' )
						nflag = 2;
					else
						nflag = 4;
					continue;
				case 'o':
					oflag++;
					break;
				case 'r':
					rflag = 1;
					continue;
				case 's':
					sflag = 1;
					continue;
				case 'm':
					mflag = 1;
					continue;
				default:
					printf(":invalid loader option: '%s'\n",fptr);
					ldexit(1);
			}
		}
		if( cflag ) {
			if( bflag + dflag + tflag + iflag + nflag ) {
				printf(":'C' option excludes 'BDTin' options\n");
				ldexit(1);
			}
		}
		if( oflag == 1 ) {
			fptr = *(++xargv);
			i--;
			strcpy(outfile,fptr);
			oflag++;
			continue;
		}
		if( passone(fptr,NULL,fptr,"arg") != 0 ) {	/* argument library? */
			strcpy(libname, fptr);				/* yep, copy name verbatim */
			scanlib();							/* read symbol table */
		}
	}

	resolve();

	if( !oflag )
		strcpy(outfile,ofiledef);
	if( (ofd = fopen(outfile,"w+")) == NULL ) {	/* Create output file */
		printf(":warning, can't create %s, using %s\n",outfile,ofiledef);
		if( (ofd = fopen(ofiledef,"w+")) == NULL ) {
			printf(":can't create output file '%s'\n",ofiledef);
			ldexit(1);
		}
	}
	buildhdr(0);	/* build a temp header */

	for( xargv = argv, i = argc; --i != -1; ) {
		if( *(fptr = *++xargv) == '-' ) {
			switch( *++fptr ) {
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'I':
				case 'T':
				case 'U':
				case 'X':
				case 'Z':
				case 'd':
				case 'i':
				case 'n':
				case 'r':
				case 's':
				case 'm':
					continue;
				case 'l':
					++fptr;
					if( readlib(fptr,1) )
						ldexit(1);
					continue;
				case 'F':
					process(++fptr,RELOCATE);
					continue;
				case 'o':
					xargv++;
					i--;
					continue;
			}
		}
		if( relocate(fptr,NULL,rfd,sfd,NULL,fptr,NULL) != 0 ) { /* library? */
			strcpy(libname, fptr);				/* yep, copy name verbatim */
			lpass2(libname);					/* read symbol table */
		}
	}
	if( xitflg )
		relocate(shrtexit,NULL,rfd,sfd,NULL,shrtexit,NULL);
	if( sflag == 0 || cflag )
		writesym();
	if(rflag || cflag)
		writebits();
	buildhdr(1);
	fclose(ofd);
	if( errcnt == 0 )
		chmod(outfile,0777);	/* if no errors, make it executable */
	if( cflag )
		errcnt = 0;
	ldexit(errcnt);
}

short
ldexit(flag)
short flag;
{
	if(seofd) {
		fclose(seofd);
		unlink(sefname);
	}
#ifdef LNG_NMS
	if(snofd) {
		fclose(snofd);
		unlink(snfname);
	}
#endif
	if(rofd) {
		fclose(rofd);
		unlink(rfname);
	}
	if( flag ) {
		if( ofd ) {
			fclose(ofd);
			unlink(outfile);
			printf(":'%s' removed\n",outfile);
		}
	}
	exit(flag);
}

buildhdr(flag)
int flag;
{
	register struct exec2 *hdr;
	struct exec2 hdrbuf;

	hdr = &hdrbuf;
	fseek(ofd,0L,0);
	GETCHD(ofd,hdr);
	fseek(ofd,0L,0);
	if( flag && otsize == 0 && odsize == 0 && obsize == 0 )
		printf(":warning, empty file being created\n");
	hdr->a_text = otsize;
	hdr->a_data = odsize;
	hdr->a_bss = obsize;
	if( !sflag ) {
#ifndef LNG_NMS
		hdr->a_syms = STE_SIZE;
		hdr->a_syms *= mstcnt;
#else
		hdr->a_syms = mstcnt;
#endif
	}
	else
		hdr->a_syms = 0L;
	hdr->a_stksize = 0L;
	hdr->a_entry = symtab.s_text;
	if( rflag || cflag )
		hdr->a_flag = R_BITS;		/* save relocation bits */
	else
		hdr->a_flag = R_NOBITS;	/* no bits */
	if( dflag + bflag + tflag ) {
		hdr->a_magic = E_MAGIC2;
		hdr->a_dstart = symtab.s_data;
		hdr->a_bstart = symtab.s_bss;
		PUTCHD2(ofd,hdr);
		return;
	}
	if( iflag )
		hdr->a_magic = E_IDMAGIC;
	else if( nflag == 4 )
		hdr->a_magic = E_4KMAGIC;
	else if( nflag == 2 )
		hdr->a_magic = E_2KMAGIC;
	else
		hdr->a_magic = E_MAGIC;
	PUTCHD(ofd,hdr);
}

writesym()
{
	register struct nlist *sbuf;
	register struct bssel *bptr;
	register int cnt, rbytes;
#ifdef LNG_NMS
	short wval;
	long lval;
	char buf[BSIZE];
#endif

	if( seofd == NULL )	/* no symbol file */
		return;
	sbuf = &csym;
	fflush(ofd);
	fseek(ofd,otsize+odsize+hdrsiz,0);	/* this is where they go */
	fflush(seofd);
	fseek(seofd,0L,0);
	cnt = 0;
#ifdef LNG_NMS
	lval = -1;
	lputl(&lval,ofd);
	wval = 0;
	lputw(&wval,ofd);
	lputl(&lval,ofd);
	cnt++;
	islngnms = 1;
#endif
	for (; GETSYM(sbuf,seofd,NULL,0) != ERROR; cnt++ ) {
		PUTSYM(sbuf,ofd,NULL);
	}
	for( bptr = symtab.f_bptr; bptr->n_bptr != 0; bptr = bptr->n_bptr,
			mstcnt++, cnt++ )
		PUTSYM(&bptr->b_hptr->h_sym,ofd,snofd);
#ifdef LNG_NMS
		/* Output Symbol Table Name Space */
	fflush(snofd);
	fseek(snofd,0L,0); 
	for (mstcnt=0; (rbytes = fread(buf,sizeof(char),BSIZE,snofd)) != 0; ) {
		fwrite(buf,sizeof(char),rbytes,ofd);
		mstcnt += rbytes;
	}
		/* Output Symbol Table Entry Size */
	fflush(ofd);
	fseek(ofd,otsize+odsize+hdrsiz+sizeof(long)+sizeof(short),0);
	lval = cnt * S_LSYMSIZ;
	mstcnt += lval;
	lputl(&lval,ofd);
#endif
#ifndef LNG_NMS
	if( cnt != mstcnt )
		printf(":symbol table botch\n",errcnt++);
#endif
}

writebits()
{
	register FILE *i, *o;
	short bitbuf;

	if( (i = rofd) == NULL )	/* no bits file */
		return;
	o = ofd;
	fseek(i,0L,0);
	while( fread(&bitbuf,1,sizeof (short),i) == sizeof (short) )
		fwrite(&bitbuf,1,sizeof (short),o);
}

long
gethex(sname)
register char *sname;
{
	register long result, tmp;

	result = 0L;
	while( *sname && ishex(*sname) ) {
		result <<= 4;
		if( isdigit(*sname) )
			tmp = '0';
		else {
			if( isupper(*sname) )
				*sname = tolower(*sname);
			tmp = 0x57;
		}
		result += ((long)*sname++ - tmp);
	}
	return(result);
}

process(name,type)
char *name;
register short type;
{
	register char *p, *q;
	register FILE *fp;
	FILE *rfd, *sfd;
	char nbuf[MAXUFNAME];

	if( (fp = fopen(name,"r")) == NULL ) {
		printf(":can't open file '%s'\n",name);
		errcnt++;
		return;
	}
	q = p = nbuf;
	while( (*p = getc(fp)) != EOF ) {
		if( *p == '\n' ) {
			*p = 0;
			if( type == RESOLVE )
				passone(nbuf,NULL,nbuf,"arg");
			else if( type == RELOCATE )
				relocate(nbuf,NULL,rfd,sfd,NULL,nbuf,NULL);
			else
				aliasym(nbuf,q);
			q = p = nbuf;
			continue;
		}
		if( *p == '=' && type == ALIASES ) {
			*p++ = 0;
			q = p;
			continue;
		}
		p++;
	}
	fclose(fp);
}
