/*
    Copyright 1984
    Alcyon Corporation
    8716 Production Ave.
    San Diego, Ca.  92121

    @(#)icode.h	2.5 11/16/84
*/

    /*
     * intermediate code operators
     * 0=>EOF, special operator
     */
#define EOF     0

    /*1-59=>operators that generate code (entries in code gen optab)*/
#define ADD     1
#define SUB     2
#define MULT    3
#define DIV     4
#define MOD     5
#define RSH     6
#define LSH     7
#define AND     8
#define OR      9
#define XOR     10
#define NOT     11
#define UMINUS  12
#define COMPL   13
#define PREDEC  14
#define PREINC  15
#define POSTDEC 16
#define POSTINC 17
#define ASSIGN  18
#define EQADD   19
#define EQSUB   20
#define EQMULT  21
#define EQDIV   22
#define EQMOD   23
#define EQRSH   24
#define EQLSH   25
#define EQAND   26
#define EQOR    27
#define EQXOR   28
#define FJSR    29
#define EQUALS  30
#define NEQUALS 31
#define GREAT   32
#define GREATEQ 33
#define LESS    34
#define LESSEQ  35
#define INT2L   36
#define LONG2I  37

    /*machine dependent operators that generate code*/
#define BTST    38
#define LOAD    39
#define LMULT   40
#define LDIV    41
#define LMOD    42
#define LEQMULT 43
#define LEQDIV  44
#define LEQMOD  45
#define EQADDR  46
#define EQNOT   47
#define EQNEG   48
#define DOCAST  49

#define LONG2F  50      /*[vlh] 3.4*/
#define FLOAT2L 51      /*[vlh] 3.4*/
#define INT2F   52      /*[vlh] 3.4*/
#define FLOAT2I 53      /*[vlh] 3.4*/
#define TOCHAR  54      /*[vlh] 4.1*/
#define INT2UL  55      /*[vlh] 4.4*/
#define TOUCHAR 56      /*[vlh] 4.1*/
#define FTOD    57      /*[vlh] 4.7 */
#define DTOF    58      /*[vlh] 4.7 */
#define STRASS  59      /*[vlh] structure assign */
#define LCGENOP 60      /*change if adding more operators...*/

    /*intermediate code operators that do not generate code*/
#define ADDR    60
#define INDR    61
#define LAND    62
#define LOR     63
#define QMARK   64
#define COLON   65
#define COMMA   66
#define CINT    67
#define CLONG   68
#define SYMBOL  69
#define AUTOINC 70
#define AUTODEC 71
#define CALL    72
#define NACALL  73
#define BFIELD  74
#define IFGOTO  75
#define INIT    76
#define CFORREG 77
#define DCLONG  78
#define CDOUBLE 79
#define LRCOMMA 80      /* [vlh] 4.7 */

    /*operators local to parser*/
#ifdef PARSER
#   define CAST    81
#   define SEMI    82
#   define LCURBR  83
#   define RCURBR  84
#   define LBRACK  85
#   define RBRACK  86
#   define LPAREN  87
#   define RPAREN  88
#   define STRING  89
#   define RESWORD 90
#   define APTR    91
#   define PERIOD  92
#   define SIZEOF  93
#   define MPARENS 94
#   define FRETURN 95
#   define ASM     96       /* [vlh] 4.2 */
#   define STACKEND    100
#endif

    /*operators local to code generator*/
#ifdef CGEN
#   define CFLOAT  81       /* [vlh] 4.7 */
#endif

    /*data types*/
#define TYPELESS    0
#define CHAR        01
#define ENUM        02  /* [vlh] 4.4, added */
#define SHORT       03  /* [vlh] 4.4, was 02 */
#define INT         03
#define LONG        04
#define UCHAR       05
#define VOID        06
#define USHORT      07  /* [vlh] 4.4, was 06 */
#define UNSIGNED    07
#define ULONG       010
#define FLOAT       011
#define DOUBLE      012

    /*data types local to parser*/
#define STRUCT      013
#define FRSTRUCT    014
#define LLABEL      015
#define UNION       016 /* [vlh] 4.4, added */
#define FRUNION     017 /* [vlh] 4.4, added */

    /*type flags and definitions*/
#define TYPE        017
#define SUPTYP      060
#define ALLTYPE     077
#define POINTER     020
#define FUNCTION    040
#define ARRAY       060
#define SUTYPLEN    2

    /*data registers*/
#define DREG0   0
#define DREG2   2
#define DREG3   3
#define DREG4   4
#define DREG5   5
#define DREG6   6
#define DREG7   7
#define AREG3   11
#define AREG4   12
#define AREG5   13

    /*storage classes*/
#define AUTO        1
#define REGISTER    2
#define EXTERNAL    3
#define STATIC      4
#define REGOFF      5
#define EXTOFF      6
#define STATOFF     7
#define INDEXED     8

    /*exclusively code generator storage classes*/
#define CINDR       9
#define CLINDR      10
#define CFINDR      11  /* [vlh] 3.4 */

    /*exclusively parser storage classes*/
#define STRPROTO    9
#define PDECLIST    10
#define PARMLIST    11
#define BFIELDCL    12
#define UNELCL      13
#define STELCL      14
#define PDECREG     15  /* [vlh] 4.3, PDECLIST register variable */
#define DEXTERN     16  /* [vlh] 4.3, explicitly defined extern */

    /*opinfo table bits*/
#define OPPRI       077
#define OPBIN       0100
#define OPLVAL      0200
#define OPREL       0400
#define OPASSIGN    01000
#define OPLWORD     02000
#define OPRWORD     04000
#define OPCOM       010000
#define OPRAS       020000
#define OPTERM      040000
#define OPCONVS     0100000

    /*68000 definitions*/
#define DOUBSIZE    8
#define PTRSIZE     4
#define LONGSIZE    4
#define SHORTSIZE   2
#ifndef NO32INT
#   define INTSIZE     (longint)?LONGSIZE:SHORTSIZE
#else
#   define INTSIZE     2
#endif
#define CHARSIZE    1
#ifndef LNG_NMS
#   define SSIZE    8               /* chars per symbol */
#else
#   define SSIZE    128             /* [vlh] 4.9 chars per symbol */
#endif
#define TRUE        1
#define FALSE       0
#define TABC        '\t'            /* tab character */
#define EOLC        '\n'            /* end of line character */
#define BITSPBYTE   8

    /*operator class priorities*/
#define TRMPRI      0               /* terminal nodes */
#define RPNPRI      1               /* ) and ] */
#define CALPRI      2               /* in-stack call, ( or [ */
#define COLPRI      3               /* init or case priority for : or , */
#define STKPRI      4               /* priority of end of stack */
#define COMPRI      5               /* normal priority for , */
#define ASGPRI      6               /* =, +=, -=, *=, /=, %=, ... */
#define QMKPRI      7               /* ?: */
#define LORPRI      8               /* || */
#define LNDPRI      9               /* && */
#define ORPRI       10              /* |, ^ */
#define ANDPRI      11              /* & */
#define EQLPRI      12              /* ==, != */
#define RELPRI      13              /* >, <, >=, <= */
#define SHFPRI      14              /* <<, >> */
#define ADDPRI      15              /* +, - */
#define MULPRI      16              /* *, /, % */
#define UNOPRI      17              /* !, ++, --, &, *, -, ~, sizeof */
#define LPNPRI      18              /* ., ->, [, (, function call */
#define PSTPRI      19              /* in-stack post--, post++ */

#ifdef vax11c
#   define VMS   1
#   define VAX11 1
#   define DECC  1
#endif
#ifndef VAX11
    struct { short hiword; short loword; };
#else
#   ifndef VMS
#       define UNIX 1
#   endif
    struct { short loword; short hiword; };
#endif

#ifdef PDP11
#   define UNIX 1
#endif

#ifndef DECC
#   define NORM_EXIT 0
#   define BAD_EXIT  1
#else
#   define NORM_EXIT 1
#   define BAD_EXIT  -1
#endif

#define EXPSIZE     4096    /* EXPSIZE enlarged [vlh] 4.1 */
char exprarea[EXPSIZE];     /* made char [vlh] 4.2 */

/* v6io buffer declaration */
#define BLEN    512

