/*
    Copyright 1982, 1983
    Alcyon Corporation
    8716 Production Ave.
    San Diego, Ca.  92121
*/

char *version = "@(#)main.c	2.2	11/19/84";

#include "preproc.h"

#define NARGS   64
#define FLAGS "[-C] [-P] [-E] [-D] [-I] [-6] [-7] [-3]"
#define USAGE "usage: %s %s source [dest]\n"
#define TOUPPER(c)  ((c) & ~32)

#ifdef REGULUS
	char *v6incl    = "/usr/include/v6";
	char *v7incl    = "/usr/include/v7";
	char *s3incl    = "/usr/include/sys3";
	char *ucbincl   = "/usr/include/ucb";
	char *s5incl    = "/usr/include/sys5";
#endif

#ifdef UNIX
	char *v6incl    = "/usr/include/c68/v6";
	char *v7incl    = "/usr/include/c68/v7";
	char *s3incl    = "/usr/include/c68/sys3";
	char *ucbincl   = "/usr/include/c68/ucb";
	char *s5incl    = "/usr/include/c68/sys5";
#endif

#ifdef DECC
	char *v6incl    = "v6";
	char *v7incl    = "v7";
	char *s3incl    = "sys3";
	char *ucbincl   = "ucb";
	char *s5incl    = "sys5";
#	define BAD_EXIT  -1
#	define GOOD_EXIT 1
#else
#	define BAD_EXIT  1
#	define GOOD_EXIT 0
#endif

#ifdef WHITE
		char *v6incl    = "lib:";
		char *v7incl    = "lib:";
		char *s3incl    = "lib:";
		char *ucbincl   = "lib:";
		char *s5incl    = "lib:";
#endif

#ifdef CPM
	char *v6incl    = "";
	char *v7incl    = "";
	char *s3incl    = "";
	char *ucbincl   = "";
	char *s5incl    = "";
#	define CPMDEFINES 1
#endif

#ifdef VERSADOS
#	define v6fflush fflush
	char *v6incl    = "";
	char *v7incl    = "";
	char *s3incl    = "";
	char *ucbincl   = "";
	char *s5incl    = "";
#endif

char *stdincl;				/* defined in macro.c */
char *incl[NINCL];
int ndefs, nudefs, nincl;
int status = 0;

char *predefined[] = {
	"MC68000",
	"mc68000",
#ifndef CPMDEFINES
#	ifndef VERSADOS
	"REGULUS",
	"regulus",
#	else
	"VERSADOS",
	"versados",
#	endif
#else
	"CPM",
	"cpm",
#endif
	"\0\0\0\0\0\0\0\0",
	"\0\0\0\0\0\0\0\0",
	"\0\0\0\0\0\0\0\0",
	"\0"
};

#ifndef VERSADOS
extern struct iob fout;
#endif

/*
 * main - main routine for c68 Compiler system
 *      Handles the C68 arguments.  For each C file given, the macro
 *      pre-processor is called, then the parser, code generator and
 *      assember are fexec'd.  The loader arguments are collected and
 *      the loader is fexec'd.
 */
main(argc,argv)
int argc;
register char **argv;
{
#ifdef DARKAGES
	register char *p;
#endif
    register char *arg, **dp, *calledby;
    register int c, i, j, x;

    calledby = *argv++; 
#ifdef CPM
    calledby = "cpp68";
#endif
	if (argc < 2) {	/* cpp source */
		printf(USAGE,calledby,FLAGS);
		exit(BAD_EXIT);
	}
	for (dp=predefined; **dp; dp++) {	/* [vlh] 4.7, predefined values */
		defs[ndefs].ptr = *dp;
		defs[ndefs++].value = 0;
	}
	
    for( ; --argc > 0 && **argv == '-'; ) {       /*process arguments*/
		*(arg = *argv++);
        arg++;
        for( i = 0; c = *arg++; ) {	
			
			switch( c ) {

				case 'D':
				case 'd':
					defs[ndefs].ptr = arg;
					if ((x=index(arg,'=')) != -1) {
						defs[ndefs++].value = (arg+x+1);
						arg[x] = 0; /*get rid of value*/
					}
					else 
						defs[ndefs++].value = 0;
					i++;
#ifdef	DARKAGES									/*sw Up-case the argument */
					p = defs[ndefs-1].ptr;
					while(*p) {
						*p = TOUPPER(*p);
						p++;
					}
#endif
					break;

				case 'U':	/* [vlh] 4.7 */
				case 'u':
					undefar[nudefs++] = arg;
					i++;
#ifdef	DARKAGES									/*sw Up-case the argument */
					p = undefar[nudefs-1];
					while(*p) {
						*p = TOUPPER(*p);
						p++;
					}
#endif
					break;

				case 'I':
				case 'i':
#ifdef	DARKAGES
					stdincl = *argv++;		/*sw Compatible with our past...*/
					--argc;
#else
					incl[nincl++] = arg;
					i++;
#endif
					break;

				case 'C':	/* [vlh] 4.2 Leave comments in... */
				case 'c':	/* [vlh] 4.2 Leave comments in... */
					Cflag++;
				case 'E':   /* [vlh] 4.0 Preprocessor to stdout */
				case 'e':   /* [vlh] 4.0 Preprocessor to stdout */
					Eflag++;
					continue;

				case 'P':	/* preprocessor pass only */
				case 'p':	/* preprocessor pass only */
					pflag++;
					continue;

				case 'w':	/* don't generate any warnings */
					nowarn++;
					continue;

				case '6':       /* [vlh] 3.4 v6 compatibility */
					incl[nincl++] = v6incl;
					continue;

				case '7':       /* [vlh] 3.4 v7 compatibility */
					incl[nincl++] = v7incl;
					continue;

				case '3':       /* [vlh] 3.4 s3 compatibility */
					incl[nincl++] = s3incl;
					continue;

				case '4':       /* [vlh] 4.3 ucb compatibility */
					incl[nincl++] = ucbincl;
					continue;

				case '5':       /* [vlh] 3.4 s5 compatiblity */
					incl[nincl++] = s5incl;
					continue;

				default:
					printf(USAGE,calledby,FLAGS);
					exit(BAD_EXIT);

			}	/* end of case statement */
			if (i)
				break;
		}	/* end of for statement */
	}	/* end of for statement */

	if (argc > 2) {	/* source [dest] */
		printf(USAGE,calledby,FLAGS); 
		exit(BAD_EXIT); 
	}
	source = *argv++; 
	if ( !Eflag ) {
		if (argc==2)	/* destination file specified */
			strcpy(dest,*argv);
		else
			make_intermediate(); 
	}
#ifndef VERSADOS
	else
		fout.fd = 1;	/* Make it buffered !!! */
#endif
	asflag = (source[strlen(source)-1] == 's');
	domacro(ndefs,nudefs);
    cexit();
}

/* cexit - exit from C compiler driver*/
/*      This deletes any existing temps and exits with the error status.*/
cexit()                                 /* returns - none*/
{
#ifndef VERSADOS
	v6fflush(&fout);
#endif
    exit(status ? BAD_EXIT : GOOD_EXIT);
}

/* index - find the index of a character in a string*/
index(str,chr)                      /* returns index of c in str or -1*/
char *str;                          /* pointer to string to search*/
char chr;                           /* character to search for*/
{
    register char *s;
    register int i;

    for( s = str, i = 0; *s != '\0'; i++ )
    if( *s++ == chr )
        return(i);
    return(-1);
}

make_intermediate()                     /* returns pointer to string*/
{										/* if source t.c dest <= t.i */
    register char *d, *s;
    register int ndx;

    s = source;
	while ((ndx = index(s,'/')) != -1) 
        s += ndx+1;  /* [vlh] */
    for( d = dest; *d++ = *s++; ) ;
	*(d-2) = 'i';		/* overwrite termination character */
}

/**
 * itoa - integer to ASCII conversion, used to convert line #'s
**/
itoa(n,s,w)                             /* returns - none*/
int n;                                  /* number to convert*/
char *s;                                /* resulting string*/
int w;                                  /* minimum width of string*/
{
    register char *tp;
    register int i;
    char temp[8];

    if (n < 0)		/* can not have a negative line number */
        n = -n;
    i = 0;
    tp = &temp[0];
    do {
        i++;
        *tp++ = n % 10 + '0';
    } while( (n /= 10) > 0 );
    while( --w >= i )                   /*pad on left with blanks*/
        *s++ = ' ';
    while( --i >= 0 )                   /*move chars reversed*/
        *s++ = *--tp;
    *s = '\0';
}

/* atoi - turn an ascii string into a numeric value */
atoi(s)
register char *s;
{
	register int n, sign;

	while( *s==' ' || *s=='\n' || *s == '\t')
		s++;
	sign = 1;
	if( *s == '+' || *s == '-' )
		sign = (*s++=='+') ? 1 : -1;
	for( n = 0; *s >= '0' && *s <= '9'; s++ )
		n = (n * 10) + (*s - '0');
	return( sign * n );
}

/**
 * strcmp - string comparison
 *      Compares two strings for equality, less or greater.
**/
strcmp(s,t)                             /* returns 0 for equality*/
register char *s, *t;
{
    for ( ; *s == *t; s++, t++)
    if (*s == '\0')
        return(0);
    return (*s - *t);
}

strcpy(s,t)
register char *s, *t;
{
	while(*s++ = *t++)
		;
}

/**
 * strlen - string length
 *      Computes number of bytes in string.
**/
strlen(s)                               /* returns string length*/
register char *s;                       /* string to compute length*/
{
    register int n;

    for (n = 0; *s++ != '\0';)
    	n++;
    return(n);
}

/* const - alpha to int conversion, handles octal and hexidecimal*/
/*      Uses Horner's method to evaluate number.*/
const(str)                          /* returns number evaluated*/
register char *str;                 /* pointer to string to convert*/
{
    register int c, ch, i, radix;

    i = 0;
    radix = 10;
    if( *str == '0' ) {
        radix = 8;
        if( *++str == 'x' || *str == 'X' ) {
            radix = 16;
            str++;
        }
    }
    while( c = *str++ ) {
        if( (ch=TOUPPER(c)) >= 'A' && ch <= 'F' )
            c = ch - ('A'-10);
        else if( c >= '0' && c <= '9' )
            c -= '0';
        else
            break;
        if( c >= radix )
            break;
        i = i*radix + c;
    }
    return(i);
}
