
/**
 *  Copyright 1984
 *  Alcyon Corporation
 *  8716 Production Ave.
 *  San Diego, Ca.  92121
 *
 *  @(#)printf.c	2.3	8/6/84 c68 clib
**/

#define MAXFILES	15
#define BUFSIZ		80
#define STDERR      2

/**
 **	formated print
 **/

#define putch(fd, c) if (fd==STDERR) write(STDERR,&c,1); else putchar(c)

extern int __prtint();
extern char *__prtshort(), *__prtld();

printf(parlist)
char *parlist;
{
	register char **p, *lenptr, *s, *fmt;
	register int *pi, fd;
	register int n, len;
	char buf[BUFSIZ];
	short width, prec, left, longf;
	char padchar, c;
	auto (*fn)();

	p = &parlist;
	fd = 0;
	if (parlist < MAXFILES) {
		if (*p == STDERR)
			fd = STDERR;
		p++;
	}
	
	fmt = *p++;

	pi = p;
	while (c = *fmt++) {
		p = pi;
		if (c != '%') {
			putch(fd, c);
			continue;
		}
		left = 0;
		if ((c = *fmt++) == '-') {
			c = *fmt++;
			left++;
		}
		padchar = ' ';
		if (c == '0') {
			padchar = c;
			c = *fmt++;
		}
		width = -1;
		while (c >= '0' && c <= '9') {
			if (width < 0)
				width = 0;
			width = width * 10 + (c - '0');
			c = *fmt++;
		}
		prec = -1;
		if (c == '.') {
			prec = 0;
			c = *fmt++;
		}
		while (c >= '0' && c <= '9') {
			prec = prec * 10 + (c - '0');
			c = *fmt++;
		}
		longf = 0;
		if (c == 'l') {
			longf++;
			c = *fmt++;
		}
		/* we now have all the prelims out of the way;
		   let's see what we want to print */

		s = buf;
		switch (c) {

		  case 'D':		/* decimal signed */
		  case 'd':
		  case 'X':		/* hexidecimal unsigned */
		  case 'x':
		  case 'O':		/* octal unsigned */
		  case 'o':
		  case 'u':		/* decimal unsigned */
		  case 'U':		/* decimal unsigned */
			if (longf) {
				__prtint(pi++, buf, c, c=='d' || c=='D', __prtld, c == 'X');
#ifndef VAX11
				pi++;
#endif
			}
			else
				__prtint(pi++, buf, c, c=='d' || c=='D', __prtshort, 0);
			break;

		  case 's':		/* string */
		  case 'S':
			s = *p++;
			pi = p;
			break;

		  case 'c':		/* character */
		  case 'C':
			n = *pi++;
			buf[0] = n;
			buf[1] = '\0';
			break;

		  default:		/* just print the character */
			putch(fd, c);
			continue;

		}
		/* replaced a call to __length, with inline code */
		len = 0;
		lenptr = s;
		while (*lenptr++)
			len++;
		if (prec < len && prec >= 0)
			len = prec;
		n = width - len;
		if (!left) {
			if (padchar != ' ' && *s == '-') {
				len--;
				putch(fd, *s++);
			}
			while (n-- > 0)
				putch(fd, padchar);
		}
		while (len--)
			putch(fd, *s++);
		while (n-- > 0)
			putch(fd, padchar);
	}
}

static short __max32int[] = {8,4,6,3,8,4,7,4,1,2};	/* reverse order */

char *__prtld(pobj, pbuf, base, signed, digs)
long *pobj;
char **pbuf;
int base;
int signed;
char *digs;
{
	register unsigned long n;
	register char *p;
	register short i, *x;

	p = digs;
	n = *pobj;
	if (base == 'X' || base == 'x') {	/* special because of negatives */
		i = 8;
		while(n && i) {
			*p++ = n & 0xf;
			n >>= 4;
			i--;
		}
	}
	else if (base == 'O' || base == 'o') {
		i = 11;
		while(n && i) {
			*p++ = n & 7;
			n >>= 3;
			i--;
		}
		if(i==0) {
			*(p-1) &= 3;	/* only 2 bits in upper octal digit */
		}
	}
	else {	/* Decimal */
		if (signed && *pobj < 0) {
			*(*pbuf)++ = '-';
			if (*pobj == 0x80000000) {	/* special case, no >0 equiv */
				x = __max32int;
				while (*p++ = *x++)
					;
				return (--p);
			}
			n = -(*pobj);
		}
		while(n) {
			*p++ = n % 10;
			n /= 10;
		}
	}
	return (p);
}

__prtint(pobj, buf, base, signed, f, upper)
int	*pobj;
char	*buf;
int	base, signed, upper;
char	*(*f)();
{
	char digs[15];
	register char *dp;
	register short k, b;
	register char *p;

	dp = (*f)(pobj, &buf, base, signed, digs);

	if (dp == digs)
		*dp++ = 0;
	p = buf;
	while (dp != digs) {
		k = *--dp;
		if (k < 10)
			k += '0';
		else
			k += upper ? 'A'-10 : 'a'-10;
		*p++ = k;
	}
	*p = 0;
}

char *
__prtshort(pobj, pbuf, base, signed, digs)
int	*pobj;
char	**pbuf;
int	base, signed;
char	*digs;
{
	register long	n;
	register char	*p;
	register long 	b;

	p = digs;
	b = (base=='x') ? 16 : (base=='o') ? 8 : 10;
	n = *pobj;
	if (signed && n < 0) {
		n = -n;
		*(*pbuf)++ = '-';
	}
	else 
		n &= 0xffffL;	/* clear upper half */
	
	while (n != 0) {
		*p++ = n%b;
		n /= b;
	}
	return (p);
}
