
/**
 *  Copyright 1984
 *  Alcyon Corporation
 *  8716 Production Ave.
 *  San Diego, Ca.  92121
 *
 *  @(#)libput.c	2.1	7/10/84
**/
/*
	I/O independent mapping routine.  Machine specific.  Independent
	of structure padding.  Buffer must contain at least as many
	characters as is required for structure.
 */


#include "order.h"

#define BLEN	512

struct iobuf{
	int fildes;
	int nunused;
	char *xfree;
	char buff[BLEN];
};

#define FILE struct iobuf

#define doputc(byte,fp) if(putc(byte,fp) == -1) return(_FAILURE)

lputl(lp,f)			/* returns 0 for success, -1 for failure */
long *lp;			/* 32 bits */
FILE *f;
{
	doputc(lp->b1,f);
	doputc(lp->b2,f);
	doputc(lp->b3,f);
	doputc(lp->b4,f);
	return(_SUCCESS);
}

lputw(lp,f)			/* returns 0 for success, -1 for failure */
short *lp;			/* 16 bits */
FILE *f;
{
	doputc(lp->wb1,f);
	doputc(lp->wb2,f);
	return(_SUCCESS);
}

