/*
    Copyright 1983
    Alcyon Corporation
    8716 Production Ave.
    San Diego, Ca.  92121

	@(#)pass1a.c	@(#)pass1a.c	2.4	12/17/84
*/

/* reduce long relative branches to short if possible*/

#include "as68.h"

pass1a()
{
    register long reduced;
    register short writfn, i, wsize;
#ifdef VMS
	long seekpos;
#endif

    pitix = &itbuf[ITBSZ];
    reduced = itoffset = 0L; stbuf[0].itrl = 0;
    wsize = 3*STBFSIZE;     /* [vlh] don't calculate many times */
    close(itfn);
    LASTCHTFN = itfnc;
#ifndef VMS
    itfn = openfi(tfilname,RMODE,BINARY);  /*open it for reading*/
    writfn = open(tfilname,WMODE,BINARY);  /*may need to rewrite some of it*/
#else
	/* open one appended file on vax/vms.  Opening the same file
	   simultaneously may cause problems on vms. */
	writfn = itfn = open(tfilname,RWMODE);
#endif
    if(writfn<0)
        abort();
    while(1) {
        ristb();        /*read it for one statement*/
        opcpt = stbuf[2].itop.ptrw2;    /*ptr to opcode entry in main tab*/
        if(!(opcpt->flags&OPDR)) {  /*not a directive*/
            format = (opcpt->flags)&OPFF;
            p1inlen = stbuf[1].itrl;    /*pass 1 instr length guess*/
            if(((format==6 && p1inlen==4) || opcpt==jsrptr) &&
              (rlflg=stbuf[3].itrl)==TEXT) {
                nite = stbuf[0].itrl & 0377;/* # of it entries */
                pnite = &stbuf[nite].itty;  /*ptr to end of stmt*/
                modelen = stbuf[2].itrl;    /*instr mode length*/
                opdix = ITOP1;              /*first operand*/
                pitw = &stbuf[ITOP1].itty;  /*ptr to first operand*/
                loctr = stbuf[3].itop - reduced;
                expr(&p2gi);
                ival -= loctr+2L;
                if(itype==ITCN && !extflg && reloc!=ABS &&
				  pitw >= pnite) {	/* not external and no more args */
                    if(format==9) {     /*jsr*/
                        i = (ival>= -128 && ival<=127) ? p1inlen-2 :
                            (ival>= -32768 && ival<=32767) ? p1inlen-4 : 0;
                        if (!i)
                            continue;
                        stbuf[2].itop.ptrw2 = bsrptr;   /*chng to bsr*/
                    }
                    else if(ival>= -128 && ival<=127) {
                        if (ival==2)	/* branch to next instr - delete */
							i = 4;
						else			/* reduce long branch to short */
							i = 2;
                    }
                    else
                        continue;
                    fixsyadr(i);
                    reduced += i;
                    stbuf[1].itrl -= i;     /*reduced instr lenght somewhat*/
                    if(!stbuf[1].itrl)
                        stbuf[1].itrl = -1; /*ignore flag*/
#ifdef VMS
					seekpos = lseek(itfn,0,1);	/*remember current pos*/
#endif
                    if(lseek(writfn,itoffset,0) == -1L) {
                        rpterr("seek error on intermediate file\n");
                        abort();
                    }
                    if(write(writfn,&stbuf[0],wsize) != wsize) {
                        rpterr("write error on it file\n");
                        abort();
                    }
#ifdef VMS
					seekpos = lseek(itfn,seekpos,0);	/*ret to prev pos*/
#endif
                }
            }
        }
        else if(opcpt == endptr) {
            savelc[TEXT] -= reduced;
            close(writfn);
            return;
        }
    }
}

#ifndef LNG_NMS
/* fix all symbol addresses that are text based and greater than loctr*/
/*   fix means subtract al from them*/
fixsyadr(al)
{
    register char *p;
    register long l;
	register long llctr;
	register char *llmte;

    l = al;
	llctr = loctr;
	llmte = lmte;
	for (p=beginust; p<llmte; p+= STESIZE) {	/*want in order defined*/
		if( p->flags&SYRO && p->vl1 > llctr)
			p->vl1 -= l;
    }
}
#else
/* fix all symbol addresses that are text based and greater than loctr*/
/*   fix means subtract al from them*/
fixsyadr(al)
register short al;
{
    register struct symtab *psym;
	register int i, j;
	register long llctr;
	register char *llmte;

	llctr = loctr;
	llmte = lmte;
	for (i = 0; i != sbrkindex; i++) {	/*want in order defined*/
		for (psym=sbrkptrs[i], j=ICRSZMT; --j != -1 && psym < llmte; psym++) {
			if ((psym->flags&SYRO) && (psym->vl1 > llctr))
				psym->vl1 -= al;
		}
	}
}
#endif
