	TITLE	'Clock overlay for Compupro SS1 board 3/22/85 aaj'
;
no	equ	0	
yes	equ	0ffh
i8080	equ	yes		;for xlat- do not change
i8086	equ	no
cpm	equ	yes
pcdos	equ	no
;
ss1base	equ	50h		;base address of SS1 card
clkcmd	equ	ss1base + 10	;clock command register
clkdata	equ	ss1base + 11	;clock data register
read	equ	00010000b	;set this bit to read from clock 
hold	equ	01000000b	;set this bit to stop count
;
	org	100h		;processor type flag is here
;
if i8080
	db	0c3h		;show which processor we are for
endif
if i8086
	db	0E9h
endif
;
	org	0e00h		;start of clock overlay 
;
	jmp	gettim		;get time
	jmp	getdat		;get date
	ret			;cset processor
	nop
	nop
	ret			;clock overlay init
	nop
	nop
	ret			;clock overlay de-init
	nop
	nop
;
; subroutine GETTIM returns the time as follows:
;
; B - Hours (0-23)
; C - Minutes (0-59)
; D - Seconds (0-59)
; E - Hundreths of seconds (0-99) 
;
gettim:	lxi	h,0503h		;register number to h, count to l
tloop:	call	cread		;read the 10s register
	dcr	h		;point to 1s register
	add	a		;multiply this register by 10
	mov	e,a
	add	a
	add	a
	add	e
	mov 	e,a		;save in e
	call	cread		;get 1s digit
	add	e		;get total to a
	mov	b,c		;shuffle registers to get proper result
	mov	c,d
	mov	d,a
	dcr	h		;point next 10s digit
	dcr	l		;count loop
	jnz	tloop		;\loop till all digits collected
	mvi	e,0		;clear hundreths of second count
	ret			;all done
;
;
; subroutine GETDAT returns the date as follows:
; 
; BC - Year (1985-2099)
; D - Month (1=January, 2=February, etc.)
; E - Day of month (1-31)
;
getdat:	lxi	h,0c03h		;point to 10s of year register
	call	tloop		;collect the date & year
				;year in b, month-day in c-d
	mov	e,d		;day to e
	mov	d,c		;month to d
	mov	c,b		;year to bc
	mvi	b,0
	lxi	h,1900		;offset to hl 
				;(remember to change this in year 2000)
	dad	b		;get year to hl
	mov	c,l		;back to bc
	mov	b,h
	ret			;all done
;
; subroutine CREAD reads a digit from the clock chip to the A register.
; The register to read is pointed to by the H register
; All registers are preserved
;
cread:	mov	a,h		;get port address
	ori	read+hold	;add in control bits
	out	clkcmd		;send command to the chip
	cpi	5+read+hold	;check for 10's of hours 
	in	clkdata		;get the data
	push	psw		;save it
	xra	a		;reset the hold bit
	out	clkcmd
	pop	psw		;restore data & 10's of hours flag
	rnz			;return if not 10's of hours
	ani	0011b		;mask off 24hr & am-pm bits
	ret
;
	end	
;
