	title	TURBODOS OPERATING SYSTEM - XON/XOFF PRINTER DRIVER
	subttl	copyright 1983 by software 2000, inc.
	.z80
;
; copyright 1983 by software 2000, inc.
;	converted to MICROSOFT M80 format by
;	  Advanced Digital Corp.
;
; version: 02/03/83
;
	name	('lstxon')		;module id
;
	include DREQUATE.LIB		;driver symbolic equivalences
;
	dseg				;locate in data area
;
	public	xonbr
xonff::	db	aff			;form feed character
initc:	db	0,0,0,0,0,0,0,0		;initialization complete flags
	db	0,0,0,0,0,0,0,0
;
	cseg				;locate in program area
;
lstdr@::
	ld	hl,initc		;get initialization complete flags
	push	de			;save function number
	ld	e,b			;channel number to de-reg
	ld	d,0			;double length
	add	hl,de			;index into flags table
	pop	de			;restore function number
	ld	a,(hl)			;get initialization complete flag
	or	a			;initialization complete flag set?
	call	z,..init		;if not, initialize list channel
	ld	a,e			;get function number
	cp	2			;function number=2?
	jr	z,lstout		;if so, continue
	cp	7			;function number=7?
	jr	z,lstwsr		;if so, continue
	ret				;else, done

..init:	dec	(hl)			;set initialization complete flag
	push	de			;save function number
	push	bc			;save channel number/character
xonbr	equ	$+1
	ld	c,7			;get baud rate code (1200 baud)
	ld	e,3			;set function number=3
	call	serial##		;set channel buad rate
	pop	bc			;restore channel number/character
	pop	de			;restore function number
	ret				;done
;
lstwsr:	ld	a,(xonff)		;get form feed character
	ld	c,a			;form feed character to c-reg
	ld	e,2			;set function number=2
;
lstout:	call	..sst			;get serial status
	or	a			;character available?
	jr	z,..out			;if not, continue
	call	..sin			;else, get serial input
	and	7fh			;strip sign bit
	cp	adc3			;character=dc3 (xoff)?
	jr	nz,lstout		;if not, wait
..wait:	call	..sin			;get serial input
	and	7fh			;strip sign bit
	cp	adc1			;character=dc1 (xon)?
	jr	nz,..wait		;if not, wait
..out:	jp	serial##		;output character
..sst:	push	bc			;save channel number/character
	pror out
	jr	slver3
;
slvreq:	set	slvrqst,(HL)		;set slave request status bit
	dec	C			;point to data port
	ld	A,15h			;and send 15h to slave
	out	(C),A
sndwait:	
	set	sndwt,(HL)		;set send waiting status bit
	ld	HL,sndsmph		;and wait till ok to go on
	call	wait##
	jp	snd0			;now go try again
syncsig:
	ld	HL,sncsmph		;signal thru now
	jp	signal##
;
cntsnd:	pop	HL			;fix stack
	call	syncsig			;signal this run done
	call	sndsetup		;set up registers
	jr	slverxit		;and go on to exit

slver1:	pop	HL			;clear stack
slver2:	call	syncsig
	ld	A,(snddev)
slver3:	call	rsstp0			;point to signal table and set flags
	set	slvrdyf,(HL)		; slave ready flag
	res	slvrqst,(HL)		; slave requesting service
	set	systry,(HL)		; tried to load opsys
	res	sysldd,(HL)		; opsys loaded
	res	shrtmsg,(HL)		; short message
	call	failpt			;point to failure table
	inc	(HL)			;and bump counter for this slave
slverxit:	
	inc	E			;make slave no. = ckt node no.
	ld	A,(ssckt)		;get circuit no.
	ld	D,A			;and put it into d to return it
	ld	A,0ffh			;set return failure flag
	ret				;and exit

syslod:	call	rsstp0			;point to signal table
	ld	A,(HL)			;get flags for this slave
	and	40H			;have we already loaded an opsys to this slave
	xor	40H
	ret	z			;return if true
	push	HL			;save pointer to signal table
	call	failpt			;point to failure counter
	ld	A,(HL)			;bump it up
	inc	A
	pop	HL			;get hl back
	ret	z			;return if failure counter = 255
	set	sysldd,(HL)		;else set opsys loaded bit
	res	slvrdyf,(HL)		;clear slave ready bit
	ld	A,(ssckt)		;get slave circuit no.
	ld	H,A			;make up slave default network id
	ld	L,0
	ld	(ssdid##),HL		;and save in system loader
	ld	A,E			;now make up slave id
	inc	A
	ld	L,A
	ld	(sssid##),HL		;and save in system loader
	ld	HL,ssast		;point to slave system assignment table
	add	HL,DE
	ld	A,(HL)			;get down load suffix
	ld	(ssssl##),A		;and save it in system loader
	ld	A,reset			;reset slave
	out	(C),A
	ld	B,0			;and wait awhile
rstwait:	
	djnz	rstwait
	xor	A			;clear reset
	out	(C),A
	ld	HL,lodbuf		;point to opsys request buffer
	ld	B,0ah
	call	rcvblk			;get slave load request
	ret	nz			;return if there was an error
	ld	A,slvclr		;else clear slave
	out	(C),A
	ld	HL,ssload##		;get address of 1st boot loader
	ld	B,80h
	call	sndblk			;and send it
	ret	nz			;return if it didn't work
	ld	HL,ssblod##		;send load address and size of 2nd loader
	ld	B,4
	call	sndblk
	ret	nz			;leave if error
	ld	DE,(ssblen##)		;get length of 2nd loader
	ld	B,E			;put length to send in b
	ld	A,E			;correct for even page length
	or	A
	jr	nz,syssndlp
	dec	D
syssndlp:
	push	DE
	call	sndblk			;send first block
	pop	DE
	ret	nz			;exit if error in transfer
	dec	D			;more to send?
	jp	p,syssndlp		;go back if so
	xor	A			;else return with success
	ret
;
;receive poll routine node linkage
;
rcvpol:	dw	0
	dw	0
	ld	A,(nmbslv)		;get number of slaves
	or	A			;make sure we have some out there
	ret	z			;return if not
	dec	A			;else make it no. of last slave
	and	0fh
	ld	HL,rcvdev		;point hl to receive device storage
	inc	(HL)			;bump it up
	cp	(HL)			;is past max
	jr	nc,rcvprst		;skip reset if not
	ld	(HL),0
rcvprst:	
	call	rcvsetup		;set up registers and point to signal table
	bit	slvrdyf,(HL)		;is slave already ready
	ret	nz			;exit if so
	bit	slvrqst,(HL)		;is slave requesting service already
	jr	nz,rcvp0		;then skip next test
	in	A,(C)			;read slave status
	bit	svcrqst,A		;is request bit set
	jr	z,rcvp1			;skip if not
rcvp0:	res	slvrqst,(HL)		;else clear slave request set bit
	set	slvrdyf,(HL)		;set slave ready bit
	jr	rcvp2			;and skip next

rcvp1:	call	tmrchk			;check if time for slave check
	ret	c			;leave if timer not timed out
rcvp2:	set	rcvpolf,(HL)		;set receive poll flag
	ld	HL,rcvpol		;unlink ourselves
	call	unlink##
	ld	HL,rcvsmph		;and signal receive message handler
	jp	signal##
;
;send poll routine node linkage
;
sndpol:	dw	0
	dw	0
	call	sndsetup		;set up registers
	in	A,(C)			;get slave status
	bit	svcrqst,A		;is slave service request bit set
	jr	nz,sndp0		;if so skip next
	call	tmrchk			;else check if time to service anyway
	ret	c			;exit if not
	set	sndpolf,(HL)		;else set send poll bit
sndp0:	ld	HL,sndpol		;unlink send poll routine
	call	unlink##
	ld	HL,sndsmph		;and signal send message handler
	jp	signal##
;
slvtest:
	ld	A,slvatn		;set wrd02 bit in slave
	out	(C),A
	xor	A			;and clear it
	out	(C),A
	ld	B,0			;set time out counter
slvtst0:	
	in	A,(C)			;is slave in write hold
	bit	wrhld,A
	jr	nz,slvtst1		;skip out if so
	djnz	slvtst0			;go back if not timed out yet
	scf				;else set carry flag
	ret				;and return in failure
slvtst1:
	dec	C			;if slave waiting point to data port
	in	A,(C)			;get response
	inc	C			;point back to control port
	cp	6			;is response what we want
	scf				;set error flag
	ret	nz			;and return if not
	in	A,(C)			;else get control data
	and	svcrqt			;keep request bit
	ret				;and return successfully
;
sndblk:	ld	d,rdhold		;read hold mask
	call	slvrdy			;wait until ready
	ret	nz
	dec	C			;point to data port
sndb0:
	if	sprsix
	nop				;extra wait time for fast master and slow slave
	nop
	nop
	nop
	endif

	nop				;provide some extra time
	outi				;send byte
	jr	nz,sndb0		;go back if more
	jr	blkerck			;check for errors
;
rcvblk:	ld	D,wrhold		;set mask to slave write hold
	call	slvrdy			;and wait for slave to be ready to send to us
	ret	nz			;leave if slave not ready
	dec	C			;point to data port
rcvb0:
	if	sprsix
	nop				;extra wait time for fast master and slow slave
	nop
	nop
	nop
	endif

	nop				;provide some extra time
	ini				;get data byte from slave
	jr	nz,rcvb0		;and go back if more

blkerck:	
	inc	C			;point back to control port
	in	A,(C)			;get status from slave
	and	overrun			;was there any errors in transfer
	ret	z			;leave if not
	ld	A,0ffh			;else set error flag
	ret				;and exit
;
slvrdy:	ld	E,0			;load time counter
slvrdy0:	
	in	A,(C)			;get slave control port
	and	D			;keep only relevant status bit
	xor	D			;complement sense of bit
	ret	z			;will be zero if ready
	dec	E			;not ready so decrement time out count
	jr	nz,slvrdy0		;try again if not timed out
	xor	A			;else set error return flag
	dec	A
	ret				;and exit
;
waitnit:
	ld	E,A			;make device no 16 bits
	ld	D,0
	ld	HL,slvtmrtbl		;get table base
	add	HL,DE			;point into table
	ld	A,(ticcnt##)		;set element to tic count
	ld	(HL),A
	ret				;and return
;
tmrchk:	
	push	HL			;save hl
	ld	HL,slvtmrtbl		;point to slave service timer table
	add	HL,DE			;and to proper entry
	ld	A,(ticcnt##)		;get present tick count
	sub	(HL)			;find out how much time has elapsed
	pop	HL
	cp	3CH			;has it been long enough
	ret
;
rcvsetup:	
	ld	A,(rcvdev)		;get receive slave no.
	jr	rsstp0			;and go on to process it
sndsetup:
	ld	A,(snddev)		;get send slave no.
rsstp0:	ld	E,A			;make slave no 16 bits
	ld	D,0
	ld	HL,ssadt		;get base of slave port address table
	add	HL,DE			;point to address of proper slave
	ld	C,(HL)			;get base address for slave
	inc	C			;bump to point to control port
sgnlref:
	ld	HL,sgnltbl		;point into nuther table
	add	HL,DE			;proper place for this slave
	ret
;
failclr:	
	ld	E,A			;make slave no. 16 bits
	ld	D,0
	call	failpt			;point to falure table
	ld	(HL),0			;and clear entry for this slave
	ret				;and return
;
failpt:	ld	HL,flctrtbl		;point to beginning of failure table
	add	HL,DE			;and now to entry for this slave
	ret
;
	dseg				;put into data area
;
nmbslv:
nmbss@::				;number of slaves installed
	db	2
ssckt:
ssckt@::				;default slave circuit number
	db	0
ssadt:
ssadt@::				;slave port address, default is 70h-8eh
	db	70h,72h,74h,76h,78h,7ah,7ch,7eh
	db	80h,82h,84h,86h,88h,8ah,8ch,8eh
ssast:
ssast@::				;slave opsys suffix table
	db	'            