h53870
s 00053/00000/00000
d D 3.1 84/11/13 16:28:47 dan 1 0
c date and time created 84/11/13 16:28:47 by dan
e
u
U
t
T
I 1
/*  pktfuncs.h -- Declare VIOS external i/o packet support routines
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */
#ifndef PKTFUNCS
#define PKTFUNCS

#include "iopacket.h"


/* Declare i/o packet handler routines */
/* pktsubs.c */
extern PKT_PTR allpkt();		/* allocate and init a packet */
extern PKT_PTR spwnpkt();		/* allocate an offspring packet */
extern PKT_PTR duppkt();		/* duplicate an i/o packet */
extern PDD_PTR o_dup();			/* spawn journal output */
extern PDD_PTR i_dup();			/* spawn error input */
extern PDD_PTR io_dup();		/* spawn both the above */
extern PDD_PTR fnd_inp_pdd();		/* locate a Primary Input PDD */
extern PDD_PTR fnd_out_pdd();		/* locate a Primary Output PDD */

/* qsubs.c */
extern int **q_item();			/* add an item to back of queue */
extern int **pq_item();			/* add an item to priority queue */
extern int **dq_item();			/* remove first item on queue */
extern int **uq_item();			/* remove a given item from queue */
extern int **u_q_item();		/* remove a given item from queue */
extern PKT_PTR q_locate();		/* find a packet on queue */


/* Declare queue manipulation subroutines for i/o packet queues */
#define q_virtual(r)	q_item((r),&Vqueue)
#define q_wait(r)	pq_item((r),&Wqueue)
#define q_physical(r)	pq_item((r),&Pqueue)
#define dq_virtual()	(PKT_PTR) (dq_item(&Vqueue))
#define uq_virtual(r)	(PKT_PTR) (uq_item((r),&Vqueue))
#define uq_wait(r)	(PKT_PTR) (uq_item((r),&Wqueue))
#define uq_physical(r)	(PKT_PTR) (uq_item((r),&Pqueue))

/* The following activation routines check the i/o packet queues for packets
   that match a given condition/device and activate the 1st, or 'lim' */
#define pq_activate(cnd, lim, dev)	q_activate(cnd, lim, dev, &Pqueue)
#define wq_activate(cnd, lim)		q_activate(cnd, lim, NULL, &Wqueue)

/* The following routines check the i/o packet queues for packets that
   match a given condition/device and return the packet pointer without
   removing the packet from the queue */
#define pq_locate(cnd, dev)		q_locate(cnd, dev, &Pqueue)
#define wq_locate(cnd)			q_locate(cnd, NULL, &Wqueue)

#endif
E 1
