h40112
s 00009/00004/00090
d D 3.3 85/06/04 19:31:46 dock 3 2
c 
e
s 00007/00007/00087
d D 3.2 85/06/04 14:38:48 dock 2 1
c changed include files
e
s 00094/00000/00000
d D 3.1 84/11/13 16:27:19 dan 1 0
c date and time created 84/11/13 16:27:19 by dan
e
u
U
t
T
I 1
D 3
/*  devhandlr.c -- VIOS Virtual Device I/O Control request handler
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
E 3
I 3

/*
 * %M%: version %I% of %H%
E 3
 *
I 3
 *  devhandlr.c -- VIOS Virtual Device I/O Control request handler
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg	November, 1984
E 3
 */
I 3
#ifdef SCCS
static char *sccsid = "%W%";
#endif
E 3

D 2
#include "viosconf.h"
#include "devfuncs.h"
#include "pktfuncs.h"
#include "handlers.h"
#include "poolfuncs.h"
#include "viocmds.h"
#include "viostatus.h"
E 2
I 2
#include "vinc/viosconf.h"
#include "vinc/devfuncs.h"
#include "vinc/pktfuncs.h"
#include "vinc/handlers.h"
#include "vinc/poolfuncs.h"
#include "vinc/viocmds.h"
#include "vinc/viostatus.h"
E 2


    PKT_STATE					/* throws: various errors */
vdevice_handler (pkt)
    register PKT_PTR pkt;

/* vdevice_handler (pkt) -- Process VIOS VDEV_CONTROL requests
 *
 *	in:	pkt		I/O packet to process
 *	return:	(PKT_STATE)	next state of packet
 *	thrown:	V_ILL_FUNCTION	function not valid
 *		V_BAD_PARAMS	
 *		V_NO_DEVICE	no Primary Input device
 *
 *	Process Virtual I/O Control Requests in the following way:
 *
 */
{
    register IO_PACKET *pk;	/* dereferenced ptr */
    register VDD_PTR dev;

    pk = *pkt;		/* must renew after alloc() */

    switch (Stnum(pk))
	{
    case 0:
	if ( (Auxparam(pk) NE NULL) OR (Ubufsize(pk) NE 0) )
	    throw (V_BAD_PARAMS);

	dev = VDevice(pk);		/* get device and go to Class Handler */

	/* if i/o redirection is performed, spawned packets may come back */
	return((*Classdispatcher(*dev))(VDIOCTRL,pkt,dev));

#ifdef DEBUG2   /*************************************************************/
    default:
	error("vdevice_handler: bad state in pkt @ %x", pk);
#endif /* DEBUG2 *************************************************************/

	} /*switch Stnum*/
}

    PKT_STATE					/* throws: various errors */
pdevice_handler (pkt)
    register PKT_PTR pkt;

/* pdevice_handler (pkt) -- Process VIOS PDEV_CONTROL requests
 *
 *	in:	pkt		I/O packet to process
 *	return:	(PKT_STATE)	next state of packet
 *	thrown:	V_ILL_FUNCTION	function not valid
 *		V_BAD_PARAMS	
 *		V_NO_DEVICE	no Primary Input device
 *
 *	Process Physical I/O Control Requests in the following way:
 *
 */
{
    register IO_PACKET *pk;	/* dereferenced ptr */
    register PDD_PTR dev;

    pk = *pkt;		/* must renew after alloc() */

    switch (Stnum(pk))
	{
    case 0:
	if ( (Auxparam(pk) NE NULL) OR (Ubufsize(pk) NE 0) )
	    throw (V_BAD_PARAMS);

	dev = PDevice(pk);		/* get device and go to Class Handler */

	return((*Classdispatcher(*dev))(PDIOCTRL,pkt,dev));

#ifdef DEBUG2   /*************************************************************/
    default:
	error("pdevice_handler: bad state in pkt @ %x", pk);
#endif /* DEBUG2 *************************************************************/

	} /*switch Stnum*/
}
E 1
