h01806
s 00147/00000/00000
d D 1.1 85/06/04 19:21:52 dock 1 0
c date and time created 85/06/04 19:21:52 by dock
e
u
U
t
T
I 1

/*
 * %M%: version %I% of %H%
 *
 *  bufaddr.c -- Class-dependent routines for Buffer-Addressible Devices
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg	November, 1984
 */
#ifdef SCCS
static char *sccsid = "%W%";
#endif

#include "vinc/viosconf.h"
#include "vinc/iopacket.h"
#include "vinc/viocmds.h"
#include "vinc/viostatus.h"
#include "vinc/handlers.h"
#include "vinc/pktfuncs.h"
#include "vinc/poolfuncs.h"

    PKT_STATE					/* throws: various errors */
bufa_dispatcher (cmd, pkt, dev)
    int cmd;
    PKT_PTR pkt;
    VDD_PTR dev;

/* bufa_dispatcher (cmd, pkt, dev) -- Class-dependent i/o mapping dispatcher
 *
 *	in:	cmd		Type of VIOS request to handle
 *	in:	pkt		Current i/o packet ptr, if any
 *	in:	dev		Current device, if VDCREATE or VDREMOVE
 *	return:	(PKT_STATE)	Current state of i/o packet
 *	thrown:	V_ILL_MODIFIER	bad i/o request modifier
 *
 *	Perform i/o request handling for Buffer-Addressible Devices.
 *
 *	This routine is called during the processing of an i/o packet to perform
 *	any class-dependent operations or mapping of requests.  It must either
 *	verify that the request is valid for the given device class and initiate
 *	any class-dependent actions, or dispatch to a routine that will do so.
 *	(See DOCS/classdispatcher for more info on calling conditions.)
 *
 *	The processing is as follows:
 *		cmd == VDCREATE
 *		cmd == VDREMOVE
 *		cmd == PDCREATE	Copy buffer size, in bytes,
 *				from status of physical i/o to PDD.
 *		cmd == PDREMOVE
 *		cmd == VDREAD	If there is no primary input unit,
 *					throw V_NO_DEVICE.
 *				If the byte offset is out of range,
 *					throw V_BAD_PARAMS.
 *				Reset the packet to point to the primary input
 *				unit.  If the new unit is a Virtual Device,
 *					return VIO_RUN_STATE.
 *				If the new unit is a Physical Device, call
 *				q2device() (rdwrtsubs.c) and return its value.
 *		cmd == VDWRITE	If there is no primary output unit,
 *					throw V_NO_DEVICE.
 *				If the byte offset is out of range,
 *					throw V_BAD_PARAMS.
 *				Reset the packet to point to the primary output
 *				unit.  If the new unit is a Virtual Device,
 *					return VIO_RUN_STATE.
 *				If the new unit is a Physical Device, call
 *				q2device() (rdwrtsubs.c) and return its value.
 *		cmd == VDIOCTRL
 *		cmd == PDIOCTRL
 *
 *		cmd == VDINFO	Copy four parameters into user buffer of 'pkt':
 *					1) Bufa_size
 *					2) 0
 *					3) 0
 *					4) 0
 *
 *	Throws V_ILL_MODIFIER if the i/o request modifier is not valid for this
 *	class of devices.
 */
{
    register VDD *dv;
    register IO_PACKET *pk;
    register PDD_PTR pdev;

    pk = *pkt;			/* dereference everything */
    dv = *dev;

    switch (cmd)
	{
    case VDCREATE:
    case VDREMOVE:
	break;

    case PDCREATE:
	Bufa_size(dv) = Stataux2(pk);	/* set size, in bytes, from host */
	break;

    case PDREMOVE:
	break;

    case VDREAD:
	pdev = (PDD_PTR) Primaryinput(dv);
	goto Chkblk;

    case VDWRITE:
	pdev = (PDD_PTR) Primaryoutput(dv);
Chkblk:
    
	if (pdev EQ NULL) throw(V_NO_DEVICE);	/* must r/w a device */

	if ( (Param1(pk) + Ubufsize(pk)) GT Bufa_size(*pdev) )
	    throw(V_BAD_PARAMS);		/* buffer offset too large */

	if (Fmod(pk) NE 0)  throw(V_ILL_MODIFIER);

	resetdev(pkt,pdev);	/* point this packet to new unit */
	if (Devtype(*pdev) EQ VDTYPE)
	    break;		/* requeue packet if still Virtual device */

	return(q2device(pkt));	/* if Physical device, queue the packet to it */

    case VDIOCTRL:
    case PDIOCTRL:
	throw(V_ILL_FUNCTION);

#ifdef DEBUG_MAP   /***********************************************************/
    case VDMAPPOOL:
#endif /* DEBUG_MAP ***********************************************************/

	break;

    case VDINFO:			/* copy device info to user buffer */
	put_val(Bufa_size(dv), pkt);	/* 1st word to copy */
	put_val(0, pkt);		/* 2nd word to copy */
	put_val(0, pkt);		/* 3rd word to copy */
	put_val(0, pkt);		/* 4th word to copy */
	break;


#ifdef DEBUG3   /*************************************************************/
    default:
	error ("Bad command to bufa_dispatcher: %d", cmd);
#endif /* DEBUG3 *************************************************************/

	} /*switch-cmd*/

    return(VIO_RUN_STATE);		/* continue processing */
}
E 1
