h00106
s 00007/00002/00161
d D 1.4 85/06/03 18:07:05 dock 4 3
c added '>' for stepping into jsrs
e
s 00001/00002/00162
d D 1.3 84/11/30 22:18:41 dock 3 2
c used bzero to clear input buffer
e
s 00007/00020/00157
d D 1.2 84/11/09 05:58:21 dock 2 1
c removed savlin, used strncpy instead
e
s 00177/00000/00000
d D 1.1 84/11/01 22:37:27 dock 1 0
c date and time created 84/11/01 22:37:27 by dock
e
u
U
t
T
I 1
D 4
/* input.c -- routines to gather input for the monitor
E 4
I 4

/*
 * %M%: version %I% of %H%
 *
 * routines to gather input for the monitor
E 4
 * copyright (c) 1984  American Information Systems Corporation
 *  Dock Williams
 *  October, 1984
 *
 */

#include "monitor.h"
#include "ascii.h"
#include "vctype.h"



    char
getinput(inpbuf,bufsiz,oflag)
    register char *inpbuf;
    int bufsiz,oflag;
/*
 * read input line from console 
 * inpbuf is an allocated buffer, bufsiz is its size and oflag
 * signifies whether this is a open or command line input fetch
 */
{
    register int i;
    register char c;

D 3
    for (i=0; i<bufsiz; i++)
	inpbuf[i] = '\0';		/* clear buffer */
E 3
I 3
    bzero(inpbuf,bufsiz);		/* clear buffer */
E 3

    for (i=0; i<=bufsiz; i++) {

D 2
	/* read input characters */
E 2
I 2
#ifdef AUTOP
E 2
	if ((cflags & CF_AUTOP) && (*autoptr != '\0'))
I 2
	    /* read input characters from buffer */
E 2
	    c = *autoptr++;
D 2
	else c = INCHR();
E 2
I 2
	else
#endif
	    /* read input characters from terminal */
	    c = INCHR();
E 2

	c = tolower(c);		/* map upper to lower case */
	inpbuf[i] =  c;		/* store in buffer */

	switch( c ) {
	case RUBOUT:
	case '\b':
	    if(i-->0) {
		i--;
		printf("\b \b");
	    }
	    break;
	case ESC:
	    OUTCHR('\n');
	    return('\0');
	case '$':		/* change output base */
	case '\`':		/* open byte */
	case '\\':		/* open word */
	case '/':		/* open double */
	    OUTCHR(c);
	    inpbuf[i] = '\0';
	    return(c);
	case '=':
	    OUTCHR(c);
	    if(oflag) break;
	    else {
		inpbuf[i] = '\0';
	    	return(c);
	    }
	case CR:
	case LF:
	    if(oflag) {
		inpbuf[i] = '\0';
		return(c);
	    } else {
		OUTCHR('\n');
		if (i>=1) {
		    lastcmd = inpbuf [i-1];
		    if(inpbuf[i-2] != ' ' && inpbuf[i-2] != '\t') {
			inpbuf[i+1] = inpbuf[i];
			inpbuf[i] = inpbuf[i-1];
			inpbuf[i-1] = ' ';
		    }
		}
D 2
		savlin(inpbuf);
E 2
I 2
		strncpy(lastinp,inpbuf,MAXINP);
E 2
		return(i>=1 ? lastcmd : '\0');
	    }
	case '!':
	    OUTCHR(c);
	    if (i>=1 || oflag) break;
	    else {
		for (i=0;i<MAXINP;i++) {
		    if (lastinp[i]) OUTCHR(lastinp[i]);
		    inpbuf[i] = lastinp[i];
		}
		OUTCHR('\n');
		return(lastcmd);
	    }
	case '@':
	case '+':
	case '-':
	case '^':
	    OUTCHR(c);
	    if(oflag){
		inpbuf[i] = '\0';
		return(c);
	    }
	    break;
	case ',':
	case '<':
I 4
	case '>':
E 4
	    OUTCHR(c);
	    if(!oflag) {
		return(c);
	    }
	    break;
	case CTRL_V:
	    printf("^V");
	    prtsee(inpbuf[i] = INCHR());
	    break;
	default:
D 4
	    OUTCHR(c);
E 4
I 4
	    prtsee(c);
E 4
	    break;
	}
    }
    printf("input overflow\n");
}



mkargv(s,argv)
    register char *s;
    register char *argv[];
/*
 * find the number of arguments for a debugger command
 */
{
    register int cnt,i;
    register int flag;

    cnt = 0;
    flag = 1;
    for (i=0; ; i++) {
	switch (s[i]) {
	case '\t':
	case ' ':
	    if(!flag) {
		s[i] = '\0';
		flag++;
	    }
	    break;
	case '\n':
	case '\r':
	case '\0':
	    return(cnt);
	default:
	    if(flag) {
		argv[cnt] = &(s[i]);
		cnt++;
		flag = 0;
	    }
	    break;
	}
    } 
D 2
}




    static
savlin(input)
    register char *input;
/*
 * save the current command line for a possible redo
 */
{
    register int i;

    for (i=0; i<MAXINP; i++) {
	lastinp[i] = input[i];		/* save last command line */
    }
E 2
}

E 1
