/* catch3200.S -- Catch and Throw errors for NS32000
 * (c) 1984  American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 *	AIS/UNIX-System V.2  code format
 *
 *
 * This module DOES NOT save/restore floating point registers!!
 */

	.file	"catch3200.S"

#include "32032.h"
#include "RAMmonsize.m"

	.text

	.globl _catch
_catch:					/* PC of catch() on stack */
	sprd	fp,tos			/* Push FP */
	save	[r3,r4,r5,r6,r7]	/* Push non-volatile registers */
	movd	@A_cataddr,tos		/* Push last catch address */
	addr	tos,@A_cataddr		/* This stack loc is new catch addr */
	movqd	0,r0			/* Set a zero return value */
	jump	0(28(sp))		/* Return to caller after catch() */

	.globl _uncatch
_uncatch:				/* PC of uncatch() on stack */
	movd	tos,r0			/* Save return address of uncatch() */
	lprd	sp,@A_cataddr		/* Get address of catch frame */
	movd	tos,@A_cataddr		/* Pop old catch frame addr */
	adjspb	$-(7*4)			/* Point to stack before last catch() */
	jump	r0			/* Return to caller after uncatch() */
					/*   [same as jump 0(r0)] */


	.globl _rethrow
_rethrow:				/* PC on stack */
	movd	@A_lasthrown,r0		/* Fetch the last thrown error code */
	br	T6

	.globl _throw
_throw:					/* PC and Error Value on stack */
	movd	4(sp),r0		/* Fetch thrown error parameter */
	cmpqd	0,r0			/* A thrown zero is indistinguishable */
	bne	T5			/*     from the original catch() call */
	movqd	-1,r0			/* If zero thrown, set -1 */
T5:	movd	r0,@A_lasthrown		/* Save error code for next rethrow() */
T6:
	cmpqd	0,@A_cataddr		/* cataddr pointing to nothing? */
	beq	_crash			/* Yes...crash */
	lprd	sp,@A_cataddr		/* Point SP at saved catch frame */
	movd	tos,@A_cataddr		/* Pop old catch frame into cataddr */
	restore	[r3,r4,r5,r6,r7]	/* Restore saved registers */
	lprd	fp,tos			/* Restore saved FP */
	ret	0			/* Return with thrown value in R0 */


	.globl _crash
_crash:	bicpsrw	PSR_I		/* disable interrupts */
	bpt			/* KEERASH */
	br	_crash		/* Loop forever */

	.globl _brkvios
_brkvios:
	bpt			/* I hope something catches this */
	ret	0		/* return to caller */

