/*  3200info.2a.h -- Define various bits and quantities for AIS/3200 Rev-2A
 *  copyright (c) American Information Systems Corporation
 * 
 *  Daniel Steinberg
 *	November, 1984
 */

#ifndef INFO3200
#define INFO3200

/* Define clock frequencies */
#define ICU_FREQ 1000000	/* 1 MHz clock */


/* Define UART-A output port bits */
#define UART_PARENABLE	UARTA	/* UART with parity enable bits */

#define SBUS_TMOENABLE	0x08	/* Set: Enable timeout detection on AIS/Bus */
#define SBUS_PARENABLE	0x10	/* Set: Enable parity detection on AIS/Bus */
#define HOST_TMOENABLE	0x20	/* Set: Enable timeout detection on Host Bus */
#define HOST_PARENABLE	0x40	/* Set: Enable parity detection on Host Bus */
#define PICK_ENABLE	0x80	/* Set: Enable PICK data hardware assist */

/* Define UART-B output port bits */
#define UART_MAPENABLE	UARTB	/* UART with mapping enable bits */

#define HOST_MEMENABLE	0x04	/* Set: Enable Host memory mapping window */
#define ROM_MAP		0x08	/* Clr: Enable ROM mapping at location 0 */
#define LED0		0x10	/* Set: turn on LED 0 */
#define LED1		0x20	/* Set: turn on LED 1 */
#define LED2		0x40	/* Set: turn on LED 2 */
#define LED3		0x80	/* Set: turn on LED 3 */

#define DTR0		LED0	/* Controls DTR on terminal 0 */
				/* subsequent DTRs are (DTR0 << #) */
#define DTR1		LED1	/* Controls DTR on terminal 1 */
#define DTR2		LED2	/* Controls DTR on terminal 2 */
#define DTR3		LED3	/* Controls DTR on terminal 3 */


/* Define UART-A input port bits */
#define UART_TMODETECT	UARTA	/* UART with timeout detection bits */

#define	SBUS_TIMEOUT	0x10	/* Timeout on AIS/Bus */
#define SBUS_PARITY	0x20	/* Parity error on AIS/Bus */
#define	HOST_TIMEOUT	0x40	/* Timeout on Host Bus */

#define	B_SBUS_TIMEOUT	4	/* Timeout on AIS/Bus */
#define B_SBUS_PARITY	5	/* Parity error on AIS/Bus */
#define	B_HOST_TIMEOUT	6	/* Timeout on Host Bus */

/* Define UART-B input port bits */
#define UART_PWRDETECT	UARTB	/* UART with powerfail detection bits */

#define HOST_PARITY	0x10	/* Parity error on AIS/Bus */
#define DC_POWERFAIL	0x20	/* Host Bus power fail */
#define	EXTERNAL_NMI	0x40	/* Special NMI jumper for debugging */

#define B_HOST_PARITY	4	/* Parity error on AIS/Bus */
#define B_DC_POWERFAIL	5	/* Host Bus power fail */
#define	B_EXTERNAL_NMI	6	/* Special NMI jumper for debugging */

#endif
