
/*
 * cmdproc.c -- command processor for dispatching of monitor commands
 * copyright (c) 1984  American Information Systems Corporation
 *  Dock Williams
 *  October, 1984
 *
 */

#include "monitor.h"

#define TOCMD 0
#define TOEXEC 1

/*
 * cmdproc returns TOEXEC (1) for return to execution
 * and TOCMD (0) for get another command 
 */

cmdproc( cmd, input )
register char cmd;
register char *input;
{
	register int	argc;		/* argument count for command */
	register char	*cp;		/* character pointer */
	register int	i;		/* temporary counter */
	int	val;			/* value for a symbol */
	int arg0,arg1,arg2,arg3;	/* converted argument values */
	char	*argv[MAXARG];		/* argument vectors */


#ifdef AUTOP
	 /* if this is not an autoprint string call mkargv */
	 /* otherwise pass a raw string for autoprinting */
	if (*input != ';')  
#endif
	    argc = mkargv(input,argv);	/* count arguments */
					/* form vectors  */

	switch(cmd) {
	case '\0':			/* exceptional cases? */
	    break;
	case '#':			/* delete a symbol */
	    dsym(argv[0]);
	    break;
	case '+':			/* add a symbol */
	    if ( !conv(argv[1],&val) ) break;
	    asym(argv[0],val,0);	/* don't hide it */
	    break;
	case '$':			/* change open base */
	    switch (*argv[0]) {
		case 'd':
		case 'o':
		case 'x':
		case 'h':
		case 'c':
		case 'u':
		    curbase = *argv[0];
		    break;
		default:
		    goto argcerr;
	    }
	    OUTCHR('\n');
	    break;
	case '/':			/* display and change double */
	case '\\':			/* display and change word */
	case '\`':			/* display and change byte */
	    setcursize(cmd);
	    open(argv);
	    break;
	case '=':
		if (argc != 1) goto argcerr;
		else {
		    if( !conv(argv[0],&val) ) break;
		    dprint(&val, curbase, cursize);
		    OUTCHR('\n');
		}
		break;
	case '?':			/* print command synopsis */
	    if (argc > 1) synop(argv);
	    else {
		argv[0][0]= '?';
		argv[0][1] = '\0';
		synop(argv);
	    }
	    break;
#ifdef AUTOP
	case 'a':
	    if (*input == ';') {	/* set autoprint string */
		for(i=1;(input[i] != ';') && (i<MAXINP);i++)
		    autobuf[i-1] = input[i];
		autobuf[i-1] = '\0';
		autoptr = &autobuf[i-1];
		cflags |= CF_AUTOP;
	    } else if (argc==1) {	/* print current autoprint string */
		for(i=0; autobuf[i] != '\0'; i++) prtsee(autobuf[i]);
		OUTCHR('\n');
	    } else if (argc==2) {
		if (*argv[0] == 'e') autoptr = autobuf;
	    } else goto argcerr;
	    break;
#endif
	case 'b':			/* breakpoints */
	    brkpnt(argc,argv);
	    break;
	case 'c':			/* compare blocks of memory */
	    if (argc != 4) goto argcerr;
	    if ( conv(argv[0],&arg0) &&
		 conv(argv[1],&arg1) &&
		 conv(argv[2],&arg2) ) compare(arg0,arg1,arg2);
	    break;
	case 'd':			/* display chunks */
	    if (argc != 3) goto argcerr;
	    if ( conv(argv[0],&arg0) &&
		 conv(argv[1],&arg1) ) display(arg0,arg1);
	    break;
	case 'e':			/* enable bits in cflags */
	    cp = argv[0];
	    while(*cp) {
		switch (*cp++) {
		case 'u': debug_user_state = '\001';break;
		case 'p': cflags |= CF_PHYS;break;
		case 's': cflags |= CF_SYMP;break;
		case 'h': cflags |= CF_PHIDE;break;
		case 'm': cflags |= CF_MMUBRK;break;
#ifdef AUTOP
		case 'a': 
		    for(i=0;(i<MAXINP && autobuf[i] != '\0');i++);
		    autoptr = &autobuf[i];
		    cflags |= CF_AUTOP;
		    break;
#endif
		case '-':
		    while(*cp) {
			switch (*cp++) {	
			case 'u': debug_user_state = '\0';break;
			case 'p': cflags &= ~CF_PHYS;break;
			case 's': cflags &= ~CF_SYMP;break;
			case 'h': cflags &= ~CF_PHIDE;break;
			case 't': cflags &= ~CF_TRACE;break;
#ifdef AUTOP
			case 'a': cflags &= ~CF_AUTOP; break;
#endif
			case 'm': cflags &= ~CF_MMUBRK;break;
			case '*': cflags = 0;break;
			}
		    }
		}
	    }
	    break;
	case 'g':			/* go */
	    if(argc == 1) {
#ifdef DEBUG1
		printf("current pc = %x",env->pc);
#endif
	    } else {
		if ( !conv(argv[0],&env->pc) ) break;
#ifdef DEBUG1
		printf("new pc = %x",env->pc);
#endif
	    }
	    env->psr &= ~(PSR_I | PSR_P);	/* reset pending trace & ints */
	    env->msr = 0;		/* disable mapping */
	    if(visbrkset(env->pc)) {	/* check for a breakpoint */
		svbrka = (char *)env->pc;	/* set at the current address */
		clrbrk(env->pc,'t');	/* step around it, if there */
	    	cflags |= (CF_BRKREP | CF_BRKPRO);  /* replace and proceed */
		env->psr |= PSR_T;
		stepcnt = 1;
	    } else env->psr &= ~PSR_T;
	    if (vmembyte(env->pc) == BRKCODE) env->pc++;
	    cflags &= ~CF_SSTEP;	/* reset single step flag */
	    stepcnt = procnt = 0;
	    return(TOEXEC);
	case 'l':			/* list symbols */
	    if (argc != 2) goto argcerr;
	    else lsym(argv[0]);
	    break;
	case 'm':			/* move a block of memory */
	    if (argc != 4) goto argcerr;
	    if ( conv(argv[0],&arg0) &&
		 conv(argv[1],&arg1) &&
		 conv(argv[2],&arg2) ) move(arg0,arg1,arg2);
	    break;
	case 'i':			/* image loader */
	    dload();
	    break;
	case 'p':			/* proceed through breakpoints */
	    if(argc > 2) goto argcerr;
	    env->psr &= ~PSR_P;		/* reset trace trap pending */
	    if(visbrkset(env->pc)) {	/* check for a breakpoint */
		svbrka = (char *)env->pc;	/* set at the current address */
		clrbrk(env->pc,'t');	/* step around it, if there */
	    	cflags |= (CF_BRKREP | CF_BRKPRO);  /* replace and proceed */
		env->psr |= PSR_T;
		stepcnt = 1;
	    } else env->psr &= ~PSR_T;	
	    if (vmembyte(env->pc) == BRKCODE) env->pc++;
	    cflags &= ~CF_SSTEP;	/* reset single step flag */
	    if (argc == 1) {	
		procnt = 0;
		return(TOEXEC);
	    } else if (argc == 2) {
		if ( !conv(argv[0],&procnt) ) break;
		return(TOEXEC);	
	    } else goto argcerr;
	case 'x':
	    ramless_monitor();
	    break;
	case 'r':			/* print registers */
	    if(argc == 1) rcpu();
	    else if (argc == 2) 
		switch(*argv[0]) {
		case 'c':	rcpu(); break;
		case 'm':	rmmu(); break;
		case 'f':	rfpu(); break;
		default:	break;
		}
	    break;
	case 's':
	case ',':			/* single step */
	case '<':			/* step over calls */
	    if(argc>2) goto argcerr;
	    cflags |= CF_SSTEP;		/* set single step flag */
	    if(visbrkset(env->pc)) {	/* check for a breakpoint */
		svbrka = (char *)env->pc;	/* set at the current address */
		clrbrk(env->pc,'t');	/* step around it, if there */
		cflags |= CF_BRKREP;	/* replace breakpoint */
		cflags &= ~CF_BRKPRO;	/* but dont proceed */
	    }

	    if (vmembyte(env->pc) == BRKCODE) env->pc++;

	    if (    (vmembyte(env->pc) == CXPCODE)
		 || (vmembyte(env->pc) == BSRCODE)
		 || ((vmembyte(env->pc) == JSRCODE)
		     && ((vmembyte((env->pc)+1) & 0x07) == JSR2CODE) )
	       && (cmd == '<') ) {
			vdisasm(env->pc, &val, 0);
			tempbrk = env->pc + val;
			printf("<.."); 
			if (visbrkset(env->pc)) {
				env->psr |= PSR_T;
				cflags |= CF_BRKPRO;
				stepcnt = 1;
			} 
			if (visbrkset(tempbrk)) {
				tempbrk = 0;
			} else 
				vsetbrk(tempbrk);
			env->psr &= ~(PSR_P|PSR_T);
			return(TOEXEC);
	    } else {
		env->psr |= PSR_T;	/* set the trace bit in the psr */
		if(cmd == '<') printf("<.");
		if (argc == 1) {
		    stepcnt = 1;
		    return(TOEXEC);
		} else {
		    if ( !conv(argv[0], &stepcnt) ) break;
		    return(TOEXEC);
		} 
	    }
	case 'u':
	    if( (argc < 2) || (argc > 3) ) goto argcerr;
	    if( !conv(argv[0],&arg0) ) goto argcerr;
	    arg1 = 2;			/* default count to unassemble */
	    if(argc == 3) {
		if( !conv(argv[1],&arg1) ) goto argcerr;
	    } 
	    for(i=0;i<arg1;i++) {
	    psym(arg0);
	    disasm(arg0,&arg2,1);
	    arg0 += arg2;
	    OUTCHR('\n');
	    if(quitchk()) break;
	    }
	    break;
	case 'f':		/* fill a block of memory with a constant */
	    if (argc != 4) goto argcerr;
	    if ( conv(argv[0],&arg0) &&
		 conv(argv[1],&arg1) &&
		 conv(argv[2],&arg2) ) fill(arg0,arg1,arg2);
	    break;
#ifdef MONJSR
	case 'j':
	    if(argc < 2) goto argcerr;
	    brkexec();			/* write breakpnts for execution */
	    if ( conv(argv[0],&arg0) ) {	/* must supply an address */
		conv(argv[1],&arg1);
		conv(argv[2],&arg2);
		conv(argv[3],&arg3);
	    	xcall(arg0,arg1,arg2,arg3);
	    }
	    break;
#endif
	case 'z':		/* write a location of memory */
		if (argc != 4) goto argcerr;
		if ((conv(argv[0],&arg0)) &&
		    (conv(argv[1],&arg1))) {
			switch(*argv[2]) {
			case 'b': arg2 = 1; break;
			case 'w': arg2 = 2; break;
			case 'd': arg2 = 4; break;
			}
			zap(arg0,arg1,arg2);
		}
	    break;
	default:
	    printf("unknown cmd\n");
	    break;
	}

	return(TOCMD);

	argcerr:
	    printf("arg count?\n");
}
