/*  vctype.h -- Special CTYPE.H for AIS compilations
 *  copyright (c)
 *	Daniel Steinberg
 *	September, 1983
 *
 */

#define	_U	01
#define	_L	02
#define	_N	04
#define	_S	010
#define _P	020
#define _C	040
#define _X	0100

extern	char	_vctype_[];

#define	isalpha(c)	((_vctype_+1)[c]&(_U|_L))
#define	isupper(c)	((_vctype_+1)[c]&_U)
#define	islower(c)	((_vctype_+1)[c]&_L)
#define	isdigit(c)	((_vctype_+1)[c]&_N)
#define	isxdigit(c)	((_vctype_+1)[c]&(_N|_X))
#define	isspace(c)	((_vctype_+1)[c]&_S)
#define ispunct(c)	((_vctype_+1)[c]&_P)
#define isalnum(c)	((_vctype_+1)[c]&(_U|_L|_N))
#define isprint(c)	((_vctype_+1)[c]&(_P|_U|_L|_N))
#define iscntrl(c)	((_vctype_+1)[c]&_C)
#define isascii(c)	((unsigned)(c)<=0177)

#define toupper(c)	(islower(c) ? ((c)-'a'+'A') : (c))
#define tolower(c)	(isupper(c) ? ((c)-'A'+'a') : (c))
#define toascii(c)	((c)&0177)
